/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.embeds.image;

import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import net.dv8tion.jda.core.entities.MessageEmbed;
import org.bukkit.event.Event;

public class ExprImageUrl
extends SimplePropertyExpression<Object, String> {
    private boolean proxy = false;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.proxy = parseResult.regexes.size() == 1;
        this.setExpr(exprs[0]);
        return true;
    }

    public String convert(Object image) {
        if (image instanceof MessageEmbed.ImageInfo) {
            MessageEmbed.ImageInfo img = (MessageEmbed.ImageInfo)image;
            return this.proxy ? img.getProxyUrl() : img.getUrl();
        }
        if (image instanceof MessageEmbed.Thumbnail) {
            MessageEmbed.Thumbnail img = (MessageEmbed.Thumbnail)image;
            return this.proxy ? img.getProxyUrl() : img.getUrl();
        }
        if (image instanceof MessageEmbed.Footer) {
            MessageEmbed.Footer img = (MessageEmbed.Footer)image;
            return this.proxy ? img.getProxyIconUrl() : img.getIconUrl();
        }
        if (image instanceof MessageEmbed.AuthorInfo) {
            MessageEmbed.AuthorInfo img = (MessageEmbed.AuthorInfo)image;
            return this.proxy ? img.getProxyIconUrl() : img.getIconUrl();
        }
        return null;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    protected String getPropertyName() {
        return (this.proxy ? "proxy " : "") + "image of image";
    }

    public String toString(Event e, boolean debug) {
        return "the " + (this.proxy ? "proxy " : "") + "url of " + this.getExpr().toString(e, debug);
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprImageUrl.class, String.class, "[<proxy>] url[s]", "thumbnails/imageinfos/footers/authorinfos").setName("Url of Image").setDesc("Returns the url of an embed's thumbnail, footer icon, author, icon or large image. Adding the proxy modifier to the syntax will return Discord's proxy url if possible.").setExample("broadcast \"%proxy url of {_embed}'s thumbnail%\"");
    }
}

