/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.events.base;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.Config;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.log.SkriptLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.events.base.EventListener;
import me.iblitzkriegi.vixio.events.base.SimpleVixioEvent;
import me.iblitzkriegi.vixio.registration.Registration;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.VixioGetter;
import net.dv8tion.jda.core.events.Event;

public abstract class BaseEvent<D extends Event>
extends SelfRegisteringSkriptEvent {
    public static final String APPENDED_ENDING = "[seen by %-string%]";
    private Map<Class<?>, Object> valueMap = new HashMap();
    private String stringRepresentation;
    private Trigger trigger;
    private EventListener<D> listener;
    private String bot;
    private Class<? extends org.bukkit.event.Event> bukkitClass;
    private Class<D> jdaClass;
    private String originalName;
    private Class<? extends org.bukkit.event.Event>[] originalEvents;
    private Constructor<?> constructor;

    public static Registration register(String name, Class type, Class clazz, String ... patterns) {
        return BaseEvent.register(name, APPENDED_ENDING, type, clazz, patterns);
    }

    public static Registration register(String name, String ending, Class type, Class clazz, String ... patterns) {
        int i = 0;
        while (i < patterns.length) {
            int n = i++;
            patterns[n] = patterns[n] + " " + ending;
        }
        return Vixio.getInstance().registerEvent(name, type, clazz, patterns);
    }

    public boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parser) {
        this.bot = (String)(exprs[0] == null ? null : exprs[0].getSingle());
        this.bukkitClass = Arrays.stream(((Object)((Object)this)).getClass().getDeclaredClasses()).filter(innerClass -> innerClass.getSuperclass() == SimpleVixioEvent.class).findFirst().orElse(null);
        if (this.bukkitClass == null) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getCanonicalName() + " doesn't have an inner SimpleVixioEvent class to be instantiated. Report this at https://github.com/iblitzkriegi/vixio/issues!");
        }
        try {
            this.jdaClass = (Class)((ParameterizedType)this.bukkitClass.getGenericSuperclass()).getActualTypeArguments()[0];
        }
        catch (ClassCastException e) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getCanonicalName() + "'s inner class doesn't use the same JDA event as it's parent class in it's SimpleVixioEvent. Report this at https://github.com/iblitzkriegi/vixio/issues!");
        }
        try {
            this.constructor = this.bukkitClass.getDeclaredConstructor(((Object)((Object)this)).getClass());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        this.stringRepresentation = ScriptLoader.replaceOptions((String)SkriptLogger.getNode().getKey()) + ":";
        this.originalName = ScriptLoader.getCurrentEventName();
        this.originalEvents = ScriptLoader.getCurrentEvents();
        String name = null;
        for (SkriptEventInfo event : Skript.getEvents()) {
            if (!this.bukkitClass.equals(event.c)) continue;
            name = event.getName();
        }
        ScriptLoader.setCurrentEvent((String)(name == null ? "Vixio event" : name), (Class[])new Class[]{this.bukkitClass});
        return true;
    }

    public void afterParse(Config config) {
        ScriptLoader.setCurrentEvent((String)this.originalName, (Class[])this.originalEvents);
    }

    public void register(Trigger t) {
        this.trigger = t;
        this.listener = new EventListener<Event>(this.jdaClass, JDAEvent -> {
            if (this.check(JDAEvent)) {
                SimpleVixioEvent compilerWorkaround = null;
                try {
                    compilerWorkaround = (SimpleVixioEvent)((Object)((Object)this.constructor.newInstance(new Object[]{this})));
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                SimpleVixioEvent event = compilerWorkaround;
                event.setJDAEvent(JDAEvent);
                Util.async(() -> {
                    for (Value value : this.getValues()) {
                        this.valueMap.put(value.clazz, value.getter.get(JDAEvent));
                    }
                    event.setValueMap(this.valueMap);
                    Util.sync(() -> this.getTrigger().execute((org.bukkit.event.Event)event));
                });
            }
        });
        EventListener.addListener(this.listener);
    }

    public void unregister(Trigger t) {
        this.listener.enabled = false;
        EventListener.removeListener(this.listener);
        this.listener = null;
        this.trigger = null;
    }

    public void unregisterAll() {
        this.unregister(this.trigger);
    }

    public String toString(org.bukkit.event.Event e, boolean debug) {
        return this.stringRepresentation;
    }

    public String getBot() {
        return this.bot;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public boolean check(D event) {
        return this.bot == null || this.bot.equalsIgnoreCase(Util.botFromID(((Event)event).getJDA().getSelfUser().getId()).getName());
    }

    public Class<? extends org.bukkit.event.Event> getBukkitClass() {
        return this.bukkitClass;
    }

    public Class<D> getJDAClass() {
        return this.jdaClass;
    }

    public Value[] getValues() {
        return new Value[0];
    }

    public class Value {
        private VixioGetter<D, Object> getter;
        private Class<?> clazz;

        public Value(Class<?> clazz, VixioGetter<D, Object> getter) {
            this.getter = getter;
            this.clazz = clazz;
        }
    }
}

