/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.commands;

import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.commands.DiscordArgument;
import me.iblitzkriegi.vixio.commands.DiscordCommandEvent;
import me.iblitzkriegi.vixio.commands.DiscordCommandFactory;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.User;
import org.bukkit.event.Event;

public class DiscordCommand {
    private String name;
    private List<String> aliases;
    private List<String> roles;
    private List<ChannelType> executableIn;
    private List<String> prefixes;
    private String description;
    private String usage;
    private String pattern;
    private List<String> bots;
    private Trigger trigger;
    private List<DiscordArgument<?>> arguments;

    public DiscordCommand(File script, String name, String pattern, List<DiscordArgument<?>> arguments, List<String> prefixes, List<String> aliases, String description, String usage, List<String> roles, List<ChannelType> executableIn, List<String> bots, List<TriggerItem> items) {
        this.name = name;
        if (aliases != null) {
            aliases.removeIf(alias -> alias.equalsIgnoreCase(name));
        }
        this.aliases = aliases;
        this.roles = roles;
        this.executableIn = executableIn;
        this.description = Utils.replaceEnglishChatStyles((String)description);
        this.usage = Utils.replaceEnglishChatStyles((String)usage);
        this.pattern = pattern;
        this.prefixes = prefixes;
        this.bots = bots;
        this.arguments = arguments;
        this.trigger = new Trigger(script, "discord command " + name, (SkriptEvent)new SimpleEvent(), items);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String prefix, String alias, String args, Guild guild, MessageChannel messageChannel, Channel channel, Message message, User user, Member member, JDA jda) {
        Bot bot = Vixio.getInstance().botHashMap.get(jda);
        DiscordCommandEvent event = new DiscordCommandEvent(prefix, alias, this, guild, messageChannel, channel, message, user, member, bot);
        if (args == null) {
            args = "";
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            boolean ok = DiscordCommandFactory.getInstance().parseArguments(args, this, event);
            if (!ok) {
                boolean bl = false;
                return bl;
            }
            if (!this.getExecutableIn().contains((Object)messageChannel.getType())) {
                boolean bl = false;
                return bl;
            }
            if (this.getRoles() != null && member != null) {
                if (member.getRoles().stream().noneMatch(r -> this.getRoles().contains(r.getName()))) {
                    boolean bl = false;
                    return bl;
                }
            } else if (this.bots != null && !this.bots.contains(bot.getName())) {
                boolean bl = false;
                return bl;
            }
            Util.sync(() -> this.trigger.execute((Event)event));
        }
        finally {
            log.stop();
        }
        return true;
    }

    public List<DiscordArgument<?>> getArguments() {
        return this.arguments;
    }

    public String getName() {
        return this.name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public List<String> getPrefixes() {
        return this.prefixes;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUsage() {
        return this.usage;
    }

    public List<String> getUsableAliases() {
        ArrayList<String> usableAliases = new ArrayList<String>();
        usableAliases.add(this.getName());
        if (this.getAliases() != null) {
            usableAliases.addAll(this.getAliases());
        }
        return usableAliases;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public List<ChannelType> getExecutableIn() {
        return this.executableIn;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public File getScript() {
        return this.trigger.getScript();
    }
}

