/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.tools.io;

import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import java.io.IOException;

public class SavedHeadSeekableInputStream
extends SeekableInputStream {
    private final SeekableInputStream delegate;
    private final byte[] savedHead;
    private boolean usingHead;
    private long headPosition;
    private long savedUntilPosition;

    public SavedHeadSeekableInputStream(SeekableInputStream delegate, int savedSize) {
        super(delegate.getContentLength(), delegate.getMaxSkipDistance());
        this.delegate = delegate;
        this.savedHead = new byte[savedSize];
    }

    public void loadHead() throws IOException {
        this.delegate.seek(0L);
        this.savedUntilPosition = this.read(this.savedHead, 0, this.savedHead.length);
        this.usingHead = this.savedUntilPosition > 0L;
        this.headPosition = 0L;
    }

    @Override
    public long getPosition() {
        if (this.usingHead) {
            return this.headPosition;
        }
        return this.delegate.getPosition();
    }

    @Override
    protected void seekHard(long position) throws IOException {
        if (position >= this.savedUntilPosition) {
            this.usingHead = false;
            this.delegate.seekHard(position);
        } else {
            this.usingHead = true;
            this.headPosition = position;
        }
    }

    @Override
    protected boolean canSeekHard() {
        return this.delegate.canSeekHard();
    }

    @Override
    public int read() throws IOException {
        if (this.usingHead) {
            byte result = this.savedHead[(int)this.headPosition];
            if (++this.headPosition == this.savedUntilPosition) {
                this.delegate.seek(this.savedUntilPosition);
                this.usingHead = false;
            }
            return result & 0xFF;
        }
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.usingHead) {
            return super.read(b, off, len);
        }
        return this.delegate.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.usingHead) {
            return super.skip(n);
        }
        return this.delegate.skip(n);
    }

    @Override
    public int available() throws IOException {
        if (this.usingHead) {
            return (int)(this.savedUntilPosition - this.headPosition);
        }
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

