/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.format.transcoder;

import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkEncoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class PcmChunkEncoder
implements AudioChunkEncoder {
    private final ByteBuffer encoded;
    private final ShortBuffer encodedAsShort;

    public PcmChunkEncoder(AudioDataFormat format) {
        this.encoded = ByteBuffer.allocate(format.bufferSize(2));
        if (format.codec == AudioDataFormat.Codec.PCM_S16_LE) {
            this.encoded.order(ByteOrder.LITTLE_ENDIAN);
        }
        this.encodedAsShort = this.encoded.asShortBuffer();
    }

    @Override
    public byte[] encode(ShortBuffer buffer) {
        buffer.mark();
        this.encodedAsShort.clear();
        this.encodedAsShort.put(buffer);
        this.encoded.clear();
        this.encoded.limit(this.encodedAsShort.position() * 2);
        byte[] encodedBytes = new byte[this.encoded.remaining()];
        this.encoded.get(encodedBytes);
        buffer.reset();
        return encodedBytes;
    }

    @Override
    public void close() {
    }
}

