/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.format.transcoder;

import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkEncoder;
import com.sedmelluq.discord.lavaplayer.natives.opus.OpusEncoder;
import com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class OpusChunkEncoder
implements AudioChunkEncoder {
    private final AudioDataFormat format;
    private final OpusEncoder encoder;
    private final ByteBuffer encodedBuffer = ByteBuffer.allocateDirect(4096);

    public OpusChunkEncoder(AudioConfiguration configuration, AudioDataFormat format) {
        this.encoder = new OpusEncoder(format.sampleRate, format.channelCount, configuration.getOpusEncodingQuality());
        this.format = format;
    }

    @Override
    public byte[] encode(ShortBuffer buffer) {
        this.encoder.encode(buffer, this.format.chunkSampleCount, this.encodedBuffer);
        byte[] bytes = new byte[this.encodedBuffer.remaining()];
        this.encodedBuffer.get(bytes);
        return bytes;
    }

    @Override
    public void close() {
        this.encoder.close();
    }
}

