/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.flac;

import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import com.sedmelluq.discord.lavaplayer.container.flac.FlacAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.flac.FlacFileLoader;
import com.sedmelluq.discord.lavaplayer.container.flac.FlacTrackInfo;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlacContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(FlacContainerProbe.class);
    private static final String TITLE_TAG = "TITLE";
    private static final String ARTIST_TAG = "ARTIST";

    @Override
    public String getName() {
        return "flac";
    }

    @Override
    public boolean matchesHints(MediaContainerHints hints) {
        return false;
    }

    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream inputStream) throws IOException {
        if (!MediaContainerDetection.checkNextBytes(inputStream, FlacFileLoader.FLAC_CC)) {
            return null;
        }
        log.debug("Track {} is a FLAC file.", (Object)reference.identifier);
        FlacTrackInfo trackInfo = new FlacFileLoader(inputStream).parseHeaders();
        return new MediaContainerDetectionResult((MediaContainerProbe)this, new AudioTrackInfo(DataFormatTools.defaultOnNull(trackInfo.tags.get(TITLE_TAG), "Unknown title"), DataFormatTools.defaultOnNull(trackInfo.tags.get(ARTIST_TAG), "Unknown artist"), trackInfo.duration, reference.identifier, false, reference.identifier));
    }

    @Override
    public AudioTrack createTrack(AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        return new FlacAudioTrack(trackInfo, inputStream);
    }
}

