/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.webhook;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.requests.Requester;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.MiscUtil;
import net.dv8tion.jda.webhook.WebhookMessageBuilder;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebhookMessage {
    protected static final MediaType OCTET = MediaType.parse("application/octet-stream");
    protected final String username;
    protected final String avatarUrl;
    protected final String content;
    protected final String fileName;
    protected final List<MessageEmbed> embeds;
    protected final boolean isTTS;
    protected final InputStream file;

    protected WebhookMessage(String username, String avatarUrl, String content, List<MessageEmbed> embeds, boolean isTTS, InputStream file, String fileName) {
        this.username = username;
        this.avatarUrl = avatarUrl;
        this.content = content;
        this.embeds = embeds;
        this.isTTS = isTTS;
        this.file = file;
        this.fileName = fileName;
    }

    public static WebhookMessage of(MessageEmbed ... embeds) {
        return new WebhookMessageBuilder().addEmbeds(embeds).build();
    }

    public static WebhookMessage of(Collection<MessageEmbed> embeds) {
        return new WebhookMessageBuilder().addEmbeds(embeds).build();
    }

    public static WebhookMessage from(Message message) {
        Checks.notNull(message, "Message");
        String content = message.getContentRaw();
        List<MessageEmbed> embeds = message.getEmbeds();
        boolean isTTS = message.isTTS();
        return new WebhookMessage(null, null, content, embeds, isTTS, null, null);
    }

    public boolean isFile() {
        return this.file != null;
    }

    protected RequestBody getBody() {
        JSONObject payload = new JSONObject();
        if (this.content != null) {
            payload.put("content", this.content);
        }
        if (!this.embeds.isEmpty()) {
            JSONArray array = new JSONArray();
            for (MessageEmbed embed : this.embeds) {
                array.put(embed.toJSONObject());
            }
            payload.put("embeds", array);
        }
        if (this.avatarUrl != null) {
            payload.put("avatar_url", this.avatarUrl);
        }
        if (this.username != null) {
            payload.put("username", this.username);
        }
        payload.put("tts", this.isTTS);
        if (this.isFile()) {
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            return builder.addFormDataPart("file", this.fileName, MiscUtil.createRequestBody(OCTET, this.file)).addFormDataPart("payload_json", payload.toString()).build();
        }
        return RequestBody.create(Requester.MEDIA_TYPE_JSON, payload.toString());
    }
}

