/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.JDAInfo;
import net.dv8tion.jda.core.ShardedRateLimiter;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.requests.RateLimiter;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.ratelimit.BotRateLimiter;
import net.dv8tion.jda.core.requests.ratelimit.ClientRateLimiter;
import net.dv8tion.jda.core.utils.JDALogger;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.http.HttpMethod;
import org.slf4j.Logger;

public class Requester {
    public static final Logger LOG = JDALogger.getLog(Requester.class);
    public static final String DISCORD_API_PREFIX = String.format("https://discordapp.com/api/v%d/", 6);
    public static final String USER_AGENT = "DiscordBot (https://github.com/DV8FromTheWorld/JDA, " + JDAInfo.VERSION + ")";
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse("application/json; charset=utf-8");
    public static final RequestBody EMPTY_BODY = RequestBody.create(null, new byte[0]);
    protected final JDAImpl api;
    private final RateLimiter rateLimiter;
    private final OkHttpClient httpClient;
    private volatile boolean retryOnTimeout = false;

    public Requester(JDA api, ShardedRateLimiter shardedRateLimiter) {
        this(api, api.getAccountType(), shardedRateLimiter);
    }

    public Requester(JDA api, AccountType accountType, ShardedRateLimiter shardedRateLimiter) {
        if (accountType == null) {
            throw new NullPointerException("Provided accountType was null!");
        }
        this.api = (JDAImpl)api;
        this.rateLimiter = accountType == AccountType.BOT ? new BotRateLimiter(this, 5, shardedRateLimiter) : new ClientRateLimiter(this, 5);
        this.httpClient = this.api.getHttpClientBuilder().build();
    }

    public JDAImpl getJDA() {
        return this.api;
    }

    public <T> void request(Request<T> apiRequest) {
        if (this.rateLimiter.isShutdown) {
            throw new IllegalStateException("The Requester has been shutdown! No new requests can be requested!");
        }
        if (apiRequest.shouldQueue()) {
            this.rateLimiter.queueRequest(apiRequest);
        } else {
            this.execute(apiRequest, true);
        }
    }

    public Long execute(Request<?> apiRequest) {
        return this.execute(apiRequest, false);
    }

    public Long execute(Request<?> apiRequest, boolean handleOnRateLimit) {
        return this.execute(apiRequest, false, handleOnRateLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long execute(Request<?> apiRequest, boolean retried, boolean handleOnRatelimit) {
        Long l;
        Route.CompiledRoute route = apiRequest.getRoute();
        Long retryAfter = this.rateLimiter.getRateLimit(route);
        if (retryAfter != null) {
            if (handleOnRatelimit) {
                apiRequest.handleResponse(new Response(retryAfter, Collections.emptySet()));
            }
            return retryAfter;
        }
        Request.Builder builder = new Request.Builder();
        String url = DISCORD_API_PREFIX + route.getCompiledRoute();
        builder.url(url);
        String method = apiRequest.getRoute().getMethod().toString();
        RequestBody body = apiRequest.getBody();
        if (body == null && HttpMethod.requiresRequestBody(method)) {
            body = EMPTY_BODY;
        }
        builder.method(method, body).header("user-agent", USER_AGENT).header("accept-encoding", "gzip");
        if (url.startsWith(DISCORD_API_PREFIX) && this.api.getToken() != null) {
            builder.header("authorization", this.api.getToken());
        }
        if (apiRequest.getHeaders() != null) {
            for (Map.Entry header : apiRequest.getHeaders().entrySet()) {
                builder.addHeader((String)header.getKey(), (String)header.getValue());
            }
        }
        okhttp3.Request request = builder.build();
        LinkedHashSet<String> rays = new LinkedHashSet<String>();
        okhttp3.Response[] responses = new okhttp3.Response[4];
        okhttp3.Response firstSuccess = null;
        try {
            int attempt = 0;
            do {
                if (apiRequest.isCanceled()) {
                    l = null;
                    return l;
                }
                Call call = this.httpClient.newCall(request);
                responses[attempt] = firstSuccess = call.execute();
                String cfRay = firstSuccess.header("CF-RAY");
                if (cfRay != null) {
                    rays.add(cfRay);
                }
                if (firstSuccess.code() < 500) break;
                LOG.debug("Requesting {} -> {} returned status {}... retrying (attempt {})", new Object[]{apiRequest.getRoute().getMethod(), url, firstSuccess.code(), ++attempt});
                try {
                    Thread.sleep(50 * attempt);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (attempt < 3 && firstSuccess.code() >= 500);
            if (firstSuccess.code() >= 500) {
                l = null;
                return l;
            }
            retryAfter = this.rateLimiter.handleResponse(route, firstSuccess);
            if (!rays.isEmpty()) {
                LOG.debug("Received response with following cf-rays: {}", (Object)rays);
            }
            if (retryAfter == null) {
                apiRequest.handleResponse(new Response(firstSuccess, -1L, rays));
            } else if (handleOnRatelimit) {
                apiRequest.handleResponse(new Response(firstSuccess, retryAfter, rays));
            }
            l = retryAfter;
            return l;
        }
        catch (SocketTimeoutException e) {
            if (this.retryOnTimeout && !retried) {
                l = this.execute(apiRequest, true, handleOnRatelimit);
                return l;
            }
            LOG.error("Requester timed out while executing a request", e);
            apiRequest.handleResponse(new Response(firstSuccess, e, rays));
            l = null;
            return l;
        }
        catch (Exception e) {
            LOG.error("There was an exception while executing a REST request", e);
            apiRequest.handleResponse(new Response(firstSuccess, e, rays));
            l = null;
            return l;
        }
        finally {
            for (okhttp3.Response r : responses) {
                if (r == null) break;
                r.close();
            }
        }
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public void setRetryOnTimeout(boolean retryOnTimeout) {
        this.retryOnTimeout = retryOnTimeout;
    }

    public void shutdown(long time, TimeUnit unit) {
        this.rateLimiter.shutdown(time, unit);
    }

    public void shutdownNow() {
        this.rateLimiter.forceShutdown();
    }

    public static InputStream getBody(okhttp3.Response response) throws IOException {
        String encoding = response.header("content-encoding", "");
        if (encoding.equals("gzip")) {
            return new GZIPInputStream(response.body().byteStream());
        }
        return response.body().byteStream();
    }
}

