/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import java.util.LinkedList;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.message.MessageBulkDeleteEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import org.json.JSONObject;

public class MessageBulkDeleteHandler
extends SocketHandler {
    public MessageBulkDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long channelId = content.getLong("channel_id");
        if (this.api.isBulkDeleteSplittingEnabled()) {
            SocketHandler handler = (SocketHandler)this.api.getClient().getHandler("MESSAGE_DELETE");
            content.getJSONArray("ids").forEach(id -> handler.handle(this.responseNumber, new JSONObject().put("t", "MESSAGE_DELETE").put("d", new JSONObject().put("channel_id", Long.toUnsignedString(channelId)).put("id", id))));
        } else {
            TextChannel channel = this.api.getTextChannelMap().get(channelId);
            if (channel == null) {
                this.api.getEventCache().cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
                EventCache.LOG.debug("Received a Bulk Message Delete for a TextChannel that is not yet cached.");
                return null;
            }
            if (this.api.getGuildLock().isLocked(channel.getGuild().getIdLong())) {
                return channel.getGuild().getIdLong();
            }
            LinkedList<String> msgIds = new LinkedList<String>();
            content.getJSONArray("ids").forEach(id -> msgIds.add((String)id));
            this.api.getEventManager().handle(new MessageBulkDeleteEvent(this.api, this.responseNumber, channel, msgIds));
        }
        return null;
    }
}

