/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import gnu.trove.map.TLongObjectMap;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.dv8tion.jda.client.requests.restaction.pagination.MentionPaginationAction;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.GuildVoiceState;
import net.dv8tion.jda.core.entities.Invite;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.Webhook;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.dv8tion.jda.core.exceptions.GuildUnavailableException;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.exceptions.PermissionException;
import net.dv8tion.jda.core.managers.AudioManager;
import net.dv8tion.jda.core.managers.GuildController;
import net.dv8tion.jda.core.managers.GuildManager;
import net.dv8tion.jda.core.managers.GuildManagerUpdatable;
import net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.pagination.AuditLogPaginationAction;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.MiscUtil;
import net.dv8tion.jda.core.utils.cache.MemberCacheView;
import net.dv8tion.jda.core.utils.cache.SnowflakeCacheView;
import net.dv8tion.jda.core.utils.cache.impl.MemberCacheViewImpl;
import net.dv8tion.jda.core.utils.cache.impl.SnowflakeCacheViewImpl;
import net.dv8tion.jda.core.utils.cache.impl.SortedSnowflakeCacheView;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GuildImpl
implements Guild {
    private final long id;
    private final JDAImpl api;
    private final SortedSnowflakeCacheView<Category> categoryCache = new SortedSnowflakeCacheView<Category>(Channel::getName, Comparator.naturalOrder());
    private final SortedSnowflakeCacheView<VoiceChannel> voiceChannelCache = new SortedSnowflakeCacheView<VoiceChannel>(Channel::getName, Comparator.naturalOrder());
    private final SortedSnowflakeCacheView<TextChannel> textChannelCache = new SortedSnowflakeCacheView<TextChannel>(Channel::getName, Comparator.naturalOrder());
    private final SortedSnowflakeCacheView<Role> roleCache = new SortedSnowflakeCacheView<Role>(Role::getName, Comparator.reverseOrder());
    private final SnowflakeCacheViewImpl<Emote> emoteCache = new SnowflakeCacheViewImpl<Emote>(Emote::getName);
    private final MemberCacheViewImpl memberCache = new MemberCacheViewImpl();
    private final TLongObjectMap<JSONObject> cachedPresences = MiscUtil.newLongMap();
    private final Object mngLock = new Object();
    private volatile GuildManager manager;
    private volatile GuildManagerUpdatable managerUpdatable;
    private volatile GuildController controller;
    private Member owner;
    private String name;
    private String iconId;
    private String splashId;
    private String region;
    private Set<String> features;
    private VoiceChannel afkChannel;
    private TextChannel systemChannel;
    private Role publicRole;
    private Guild.VerificationLevel verificationLevel;
    private Guild.NotificationLevel defaultNotificationLevel;
    private Guild.MFALevel mfaLevel;
    private Guild.ExplicitContentLevel explicitContentLevel;
    private Guild.Timeout afkTimeout;
    private boolean available;
    private boolean canSendVerification = false;

    public GuildImpl(JDAImpl api, long id) {
        this.id = id;
        this.api = api;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIconId() {
        return this.iconId;
    }

    @Override
    public String getIconUrl() {
        return this.iconId == null ? null : "https://cdn.discordapp.com/icons/" + this.id + "/" + this.iconId + ".jpg";
    }

    @Override
    public Set<String> getFeatures() {
        return this.features;
    }

    @Override
    public String getSplashId() {
        return this.splashId;
    }

    @Override
    public String getSplashUrl() {
        return this.splashId == null ? null : "https://cdn.discordapp.com/splashes/" + this.id + "/" + this.splashId + ".jpg";
    }

    @Override
    public RestAction<String> getVanityUrl() {
        if (!this.isAvailable()) {
            throw new GuildUnavailableException();
        }
        if (!this.getSelfMember().hasPermission(Permission.MANAGE_SERVER)) {
            throw new InsufficientPermissionException(Permission.MANAGE_SERVER);
        }
        if (!this.getFeatures().contains("VANITY_URL")) {
            throw new IllegalStateException("This guild doesn't have a vanity url");
        }
        Route.CompiledRoute route = Route.Guilds.GET_VANITY_URL.compile(this.getId());
        return new RestAction<String>((JDA)this.api, route){

            @Override
            protected void handleResponse(Response response, Request<String> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                request.onSuccess(response.getObject().getString("code"));
            }
        };
    }

    @Override
    public VoiceChannel getAfkChannel() {
        return this.afkChannel;
    }

    @Override
    public TextChannel getSystemChannel() {
        return this.systemChannel;
    }

    @Override
    public RestAction<List<Webhook>> getWebhooks() {
        if (!this.getSelfMember().hasPermission(Permission.MANAGE_WEBHOOKS)) {
            throw new InsufficientPermissionException(Permission.MANAGE_WEBHOOKS);
        }
        Route.CompiledRoute route = Route.Guilds.GET_WEBHOOKS.compile(this.getId());
        return new RestAction<List<Webhook>>((JDA)this.api, route){

            @Override
            protected void handleResponse(Response response, Request<List<Webhook>> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                JSONArray array = response.getArray();
                ArrayList<Webhook> webhooks = new ArrayList<Webhook>(array.length());
                EntityBuilder builder = this.api.getEntityBuilder();
                for (Object object : array) {
                    try {
                        webhooks.add(builder.createWebhook((JSONObject)object));
                    }
                    catch (NullPointerException | JSONException e) {
                        JDAImpl.LOG.error("Error creating webhook from json", e);
                    }
                }
                request.onSuccess(Collections.unmodifiableList(webhooks));
            }
        };
    }

    @Override
    public Member getOwner() {
        return this.owner;
    }

    @Override
    public Guild.Timeout getAfkTimeout() {
        return this.afkTimeout;
    }

    @Override
    public String getRegionRaw() {
        return this.region;
    }

    @Override
    public boolean isMember(User user) {
        return this.memberCache.getMap().containsKey(user.getIdLong());
    }

    @Override
    public Member getSelfMember() {
        return this.getMember(this.getJDA().getSelfUser());
    }

    @Override
    public Member getMember(User user) {
        return this.getMemberById(user.getIdLong());
    }

    @Override
    public MemberCacheView getMemberCache() {
        return this.memberCache;
    }

    @Override
    public SnowflakeCacheView<Category> getCategoryCache() {
        return this.categoryCache;
    }

    @Override
    public SnowflakeCacheView<TextChannel> getTextChannelCache() {
        return this.textChannelCache;
    }

    @Override
    public SnowflakeCacheView<VoiceChannel> getVoiceChannelCache() {
        return this.voiceChannelCache;
    }

    @Override
    public SnowflakeCacheView<Role> getRoleCache() {
        return this.roleCache;
    }

    @Override
    public SnowflakeCacheView<Emote> getEmoteCache() {
        return this.emoteCache;
    }

    @Override
    public RestAction<List<User>> getBans() {
        if (!this.isAvailable()) {
            throw new GuildUnavailableException();
        }
        if (!this.getSelfMember().hasPermission(Permission.BAN_MEMBERS)) {
            throw new InsufficientPermissionException(Permission.BAN_MEMBERS);
        }
        Route.CompiledRoute route = Route.Guilds.GET_BANS.compile(this.getId());
        return new RestAction<List<User>>((JDA)this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<List<User>> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                EntityBuilder builder = this.api.getEntityBuilder();
                LinkedList<User> bans = new LinkedList<User>();
                JSONArray bannedArr = response.getArray();
                for (int i = 0; i < bannedArr.length(); ++i) {
                    JSONObject user = bannedArr.getJSONObject(i).getJSONObject("user");
                    bans.add(builder.createFakeUser(user, false));
                }
                request.onSuccess(Collections.unmodifiableList(bans));
            }
        };
    }

    @Override
    public RestAction<Integer> getPrunableMemberCount(int days) {
        if (!this.isAvailable()) {
            throw new GuildUnavailableException();
        }
        if (!this.getSelfMember().hasPermission(Permission.KICK_MEMBERS)) {
            throw new InsufficientPermissionException(Permission.KICK_MEMBERS);
        }
        if (days < 1) {
            throw new IllegalArgumentException("Days amount must be at minimum 1 day.");
        }
        Route.CompiledRoute route = Route.Guilds.PRUNABLE_COUNT.compile(this.getId()).withQueryParams("days", Integer.toString(days));
        return new RestAction<Integer>((JDA)this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Integer> request) {
                if (response.isOk()) {
                    request.onSuccess(response.getObject().getInt("pruned"));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public Role getPublicRole() {
        return this.publicRole;
    }

    @Override
    @Nullable
    public TextChannel getDefaultChannel() {
        Role role = this.getPublicRole();
        return this.getTextChannelsMap().valueCollection().stream().filter(c -> role.hasPermission((Channel)c, Permission.MESSAGE_READ)).sorted(Comparator.naturalOrder()).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GuildManager getManager() {
        GuildManager mng = this.manager;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.manager;
                if (mng == null) {
                    mng = this.manager = new GuildManager(this);
                }
            }
        }
        return mng;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GuildManagerUpdatable getManagerUpdatable() {
        GuildManagerUpdatable mng = this.managerUpdatable;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.managerUpdatable;
                if (mng == null) {
                    mng = this.managerUpdatable = new GuildManagerUpdatable(this);
                }
            }
        }
        return mng;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GuildController getController() {
        GuildController ctrl = this.controller;
        if (ctrl == null) {
            Object object = this.mngLock;
            synchronized (object) {
                ctrl = this.controller;
                if (ctrl == null) {
                    ctrl = this.controller = new GuildController(this);
                }
            }
        }
        return ctrl;
    }

    @Override
    public MentionPaginationAction getRecentMentions() {
        AccountTypeException.check(this.getJDA().getAccountType(), AccountType.CLIENT);
        return this.getJDA().asClient().getRecentMentions(this);
    }

    @Override
    public AuditLogPaginationAction getAuditLogs() {
        return new AuditLogPaginationAction(this);
    }

    @Override
    public RestAction<Void> leave() {
        if (this.owner.equals(this.getSelfMember())) {
            throw new IllegalStateException("Cannot leave a guild that you are the owner of! Transfer guild ownership first!");
        }
        Route.CompiledRoute route = Route.Self.LEAVE_GUILD.compile(this.getId());
        return new RestAction<Void>((JDA)this.api, route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Void> delete() {
        if (this.api.getSelfUser().isMfaEnabled()) {
            throw new IllegalStateException("Cannot delete a guild without providing MFA code. Use Guild#delete(String)");
        }
        return this.delete(null);
    }

    @Override
    public RestAction<Void> delete(String mfaCode) {
        if (!this.owner.equals(this.getSelfMember())) {
            throw new PermissionException("Cannot delete a guild that you do not own!");
        }
        JSONObject mfaBody = null;
        if (this.api.getSelfUser().isMfaEnabled()) {
            Checks.notEmpty(mfaCode, "Provided MultiFactor Auth code");
            mfaBody = new JSONObject().put("code", mfaCode);
        }
        Route.CompiledRoute route = Route.Guilds.DELETE_GUILD.compile(this.getId());
        return new RestAction<Void>((JDA)this.api, route, mfaBody){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioManager getAudioManager() {
        if (!this.api.isAudioEnabled()) {
            throw new IllegalStateException("Audio is disabled. Cannot retrieve an AudioManager while audio is disabled.");
        }
        TLongObjectMap<AudioManager> managerMap = this.api.getAudioManagerMap();
        AudioManager mng = managerMap.get(this.id);
        if (mng == null) {
            TLongObjectMap<AudioManager> tLongObjectMap = managerMap;
            synchronized (tLongObjectMap) {
                mng = managerMap.get(this.id);
                if (mng == null) {
                    mng = new AudioManagerImpl(this);
                    managerMap.put(this.id, mng);
                }
            }
        }
        return mng;
    }

    @Override
    public JDAImpl getJDA() {
        return this.api;
    }

    @Override
    public List<GuildVoiceState> getVoiceStates() {
        return Collections.unmodifiableList(this.getMembersMap().valueCollection().stream().map(Member::getVoiceState).collect(Collectors.toList()));
    }

    @Override
    public Guild.VerificationLevel getVerificationLevel() {
        return this.verificationLevel;
    }

    @Override
    public Guild.NotificationLevel getDefaultNotificationLevel() {
        return this.defaultNotificationLevel;
    }

    @Override
    public Guild.MFALevel getRequiredMFALevel() {
        return this.mfaLevel;
    }

    @Override
    public Guild.ExplicitContentLevel getExplicitContentLevel() {
        return this.explicitContentLevel;
    }

    @Override
    public boolean checkVerification() {
        if (this.api.getAccountType() == AccountType.BOT) {
            return true;
        }
        if (this.canSendVerification) {
            return true;
        }
        if (this.api.getSelfUser().getPhoneNumber() != null) {
            this.canSendVerification = true;
            return true;
        }
        switch (this.verificationLevel) {
            case VERY_HIGH: {
                break;
            }
            case HIGH: {
                if (ChronoUnit.MINUTES.between(this.getSelfMember().getJoinDate(), OffsetDateTime.now()) < 10L) break;
            }
            case MEDIUM: {
                if (ChronoUnit.MINUTES.between(MiscUtil.getCreationTime(this.api.getSelfUser()), OffsetDateTime.now()) < 5L) break;
            }
            case LOW: {
                if (!this.api.getSelfUser().isVerified()) break;
            }
            case NONE: {
                this.canSendVerification = true;
                return true;
            }
            case UNKNOWN: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    public GuildImpl setAvailable(boolean available) {
        this.available = available;
        return this;
    }

    public GuildImpl setOwner(Member owner) {
        this.owner = owner;
        return this;
    }

    public GuildImpl setName(String name) {
        this.name = name;
        return this;
    }

    public GuildImpl setIconId(String iconId) {
        this.iconId = iconId;
        return this;
    }

    public GuildImpl setFeatures(Set<String> features) {
        this.features = Collections.unmodifiableSet(features);
        return this;
    }

    public GuildImpl setSplashId(String splashId) {
        this.splashId = splashId;
        return this;
    }

    public GuildImpl setRegion(String region) {
        this.region = region;
        return this;
    }

    public GuildImpl setAfkChannel(VoiceChannel afkChannel) {
        this.afkChannel = afkChannel;
        return this;
    }

    public GuildImpl setSystemChannel(TextChannel systemChannel) {
        this.systemChannel = systemChannel;
        return this;
    }

    public GuildImpl setPublicRole(Role publicRole) {
        this.publicRole = publicRole;
        return this;
    }

    public GuildImpl setVerificationLevel(Guild.VerificationLevel level) {
        this.verificationLevel = level;
        this.canSendVerification = false;
        return this;
    }

    public GuildImpl setDefaultNotificationLevel(Guild.NotificationLevel level) {
        this.defaultNotificationLevel = level;
        return this;
    }

    public GuildImpl setRequiredMFALevel(Guild.MFALevel level) {
        this.mfaLevel = level;
        return this;
    }

    public GuildImpl setExplicitContentLevel(Guild.ExplicitContentLevel level) {
        this.explicitContentLevel = level;
        return this;
    }

    public GuildImpl setAfkTimeout(Guild.Timeout afkTimeout) {
        this.afkTimeout = afkTimeout;
        return this;
    }

    public TLongObjectMap<Category> getCategoriesMap() {
        return this.categoryCache.getMap();
    }

    public TLongObjectMap<TextChannel> getTextChannelsMap() {
        return this.textChannelCache.getMap();
    }

    public TLongObjectMap<VoiceChannel> getVoiceChannelsMap() {
        return this.voiceChannelCache.getMap();
    }

    public TLongObjectMap<Member> getMembersMap() {
        return this.memberCache.getMap();
    }

    public TLongObjectMap<Role> getRolesMap() {
        return this.roleCache.getMap();
    }

    public TLongObjectMap<Emote> getEmoteMap() {
        return this.emoteCache.getMap();
    }

    public TLongObjectMap<JSONObject> getCachedPresenceMap() {
        return this.cachedPresences;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GuildImpl)) {
            return false;
        }
        GuildImpl oGuild = (GuildImpl)o;
        return this == oGuild || this.id == oGuild.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return "G:" + this.getName() + '(' + this.id + ')';
    }

    @Override
    public RestAction<List<Invite>> getInvites() {
        if (!this.getSelfMember().hasPermission(Permission.MANAGE_SERVER)) {
            throw new InsufficientPermissionException(Permission.MANAGE_SERVER);
        }
        Route.CompiledRoute route = Route.Invites.GET_GUILD_INVITES.compile(this.getId());
        return new RestAction<List<Invite>>((JDA)this.api, route){

            @Override
            protected void handleResponse(Response response, Request<List<Invite>> request) {
                if (response.isOk()) {
                    EntityBuilder entityBuilder = this.api.getEntityBuilder();
                    JSONArray array = response.getArray();
                    ArrayList<Invite> invites = new ArrayList<Invite>(array.length());
                    for (int i = 0; i < array.length(); ++i) {
                        invites.add(entityBuilder.createInvite(array.getJSONObject(i)));
                    }
                    request.onSuccess(Collections.unmodifiableList(invites));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }
}

