/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.dv8tion.jda.client.managers.EmoteManager;
import net.dv8tion.jda.client.managers.EmoteManagerUpdatable;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.AuditableRestAction;

public class EmoteImpl
implements Emote {
    private final long id;
    private final GuildImpl guild;
    private final JDAImpl api;
    private final HashSet<Role> roles;
    private final Object mngLock = new Object();
    private volatile EmoteManager manager = null;
    private volatile EmoteManagerUpdatable managerUpdatable = null;
    private boolean managed = false;
    private String name;

    public EmoteImpl(long id, GuildImpl guild) {
        this.id = id;
        this.guild = guild;
        this.api = guild.getJDA();
        this.roles = new HashSet();
    }

    public EmoteImpl(long id, JDAImpl api) {
        this.id = id;
        this.api = api;
        this.guild = null;
        this.roles = null;
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public List<Role> getRoles() {
        if (this.isFake()) {
            throw new IllegalStateException("Unable to return roles because this emote is fake. (We do not know the origin Guild of this emote)");
        }
        return Collections.unmodifiableList(new LinkedList<Role>(this.roles));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isManaged() {
        return this.managed;
    }

    @Override
    public boolean isFake() {
        return this.guild == null;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EmoteManager getManager() {
        EmoteManager m = this.manager;
        if (m == null) {
            Object object = this.mngLock;
            synchronized (object) {
                m = this.manager;
                if (m == null) {
                    m = this.manager = new EmoteManager(this);
                }
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EmoteManagerUpdatable getManagerUpdatable() {
        EmoteManagerUpdatable m = this.managerUpdatable;
        if (m == null) {
            Object object = this.mngLock;
            synchronized (object) {
                m = this.managerUpdatable;
                if (m == null) {
                    m = this.managerUpdatable = new EmoteManagerUpdatable(this);
                }
            }
        }
        return m;
    }

    @Override
    public AuditableRestAction<Void> delete() {
        if (this.isFake()) {
            throw new IllegalStateException("The emote you are trying to delete is not an actual emote we have access to (it is fake)!");
        }
        if (this.managed) {
            throw new UnsupportedOperationException("You cannot delete a managed emote!");
        }
        if (!this.guild.getSelfMember().hasPermission(Permission.MANAGE_EMOTES)) {
            throw new InsufficientPermissionException(Permission.MANAGE_EMOTES);
        }
        Route.CompiledRoute route = Route.Emotes.DELETE_EMOTE.compile(this.getGuild().getId(), this.getId());
        return new AuditableRestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public EmoteImpl setName(String name) {
        this.name = name;
        return this;
    }

    public EmoteImpl setManaged(boolean val) {
        this.managed = val;
        return this;
    }

    public HashSet<Role> getRoleSet() {
        return this.roles;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EmoteImpl)) {
            return false;
        }
        EmoteImpl oEmote = (EmoteImpl)obj;
        return this.id == oEmote.id && this.getName().equals(oEmote.getName());
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return "E:" + this.getName() + '(' + this.getIdLong() + ')';
    }

    public EmoteImpl clone() {
        if (this.isFake()) {
            return null;
        }
        EmoteImpl copy = new EmoteImpl(this.id, this.guild).setManaged(this.managed).setName(this.name);
        copy.roles.addAll(this.roles);
        return copy;
    }
}

