/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities;

import gnu.trove.map.TLongObjectMap;
import java.awt.Color;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.dv8tion.jda.bot.entities.ApplicationInfo;
import net.dv8tion.jda.bot.entities.impl.ApplicationInfoImpl;
import net.dv8tion.jda.client.entities.Application;
import net.dv8tion.jda.client.entities.AuthorizedApplication;
import net.dv8tion.jda.client.entities.Friend;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.client.entities.Relationship;
import net.dv8tion.jda.client.entities.RelationshipType;
import net.dv8tion.jda.client.entities.impl.ApplicationImpl;
import net.dv8tion.jda.client.entities.impl.AuthorizedApplicationImpl;
import net.dv8tion.jda.client.entities.impl.BlockedUserImpl;
import net.dv8tion.jda.client.entities.impl.FriendImpl;
import net.dv8tion.jda.client.entities.impl.GroupImpl;
import net.dv8tion.jda.client.entities.impl.IncomingFriendRequestImpl;
import net.dv8tion.jda.client.entities.impl.OutgoingFriendRequestImpl;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.OnlineStatus;
import net.dv8tion.jda.core.audit.ActionType;
import net.dv8tion.jda.core.audit.AuditLogChange;
import net.dv8tion.jda.core.audit.AuditLogEntry;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.EmbedType;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.Game;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Invite;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.entities.MessageReaction;
import net.dv8tion.jda.core.entities.MessageType;
import net.dv8tion.jda.core.entities.PermissionOverride;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.RichPresence;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.SelfUser;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.Webhook;
import net.dv8tion.jda.core.entities.impl.AbstractChannelImpl;
import net.dv8tion.jda.core.entities.impl.CategoryImpl;
import net.dv8tion.jda.core.entities.impl.EmoteImpl;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.GuildVoiceStateImpl;
import net.dv8tion.jda.core.entities.impl.InviteImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.MemberImpl;
import net.dv8tion.jda.core.entities.impl.PermissionOverrideImpl;
import net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import net.dv8tion.jda.core.entities.impl.ReceivedMessage;
import net.dv8tion.jda.core.entities.impl.RoleImpl;
import net.dv8tion.jda.core.entities.impl.SelfUserImpl;
import net.dv8tion.jda.core.entities.impl.SystemMessage;
import net.dv8tion.jda.core.entities.impl.TextChannelImpl;
import net.dv8tion.jda.core.entities.impl.UserImpl;
import net.dv8tion.jda.core.entities.impl.VoiceChannelImpl;
import net.dv8tion.jda.core.entities.impl.WebhookImpl;
import net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.dv8tion.jda.core.handle.GuildMembersChunkHandler;
import net.dv8tion.jda.core.handle.ReadyHandler;
import net.dv8tion.jda.core.utils.Helpers;
import net.dv8tion.jda.core.utils.JDALogger;
import net.dv8tion.jda.core.utils.MiscUtil;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

public class EntityBuilder {
    public static final Logger LOG = JDALogger.getLog(EntityBuilder.class);
    public static final String MISSING_CHANNEL = "MISSING_CHANNEL";
    public static final String MISSING_USER = "MISSING_USER";
    public static final String UNKNOWN_MESSAGE_TYPE = "UNKNOWN_MESSAGE_TYPE";
    protected final JDAImpl api;
    protected final TLongObjectMap<JSONObject> cachedGuildJsons = MiscUtil.newLongMap();
    protected final TLongObjectMap<Consumer<Guild>> cachedGuildCallbacks = MiscUtil.newLongMap();

    public EntityBuilder(JDA api) {
        this.api = (JDAImpl)api;
    }

    public SelfUser createSelfUser(JSONObject self) {
        SelfUserImpl selfUser = (SelfUserImpl)this.api.getSelfUser();
        if (selfUser == null) {
            long id = self.getLong("id");
            selfUser = new SelfUserImpl(id, this.api);
            this.api.setSelfUser(selfUser);
        }
        if (!this.api.getUserMap().containsKey(selfUser.getIdLong())) {
            this.api.getUserMap().put(selfUser.getIdLong(), selfUser);
        }
        selfUser.setVerified(self.getBoolean("verified")).setMfaEnabled(self.getBoolean("mfa_enabled")).setName(self.getString("username")).setDiscriminator(self.getString("discriminator")).setAvatarId(self.optString("avatar", null)).setBot(Helpers.optBoolean(self, "bot"));
        if (this.api.getAccountType() == AccountType.CLIENT) {
            selfUser.setEmail(self.optString("email", null)).setMobile(Helpers.optBoolean(self, "mobile")).setNitro(Helpers.optBoolean(self, "premium")).setPhoneNumber(self.optString("phone", null));
        }
        return selfUser;
    }

    public Game createGame(String name, String url, Game.GameType type) {
        return new Game(name, url, type);
    }

    public void createGuildFirstPass(JSONObject guild, Consumer<Guild> secondPassCallback) {
        JSONArray channels;
        Member owner;
        int i;
        long id = guild.getLong("id");
        GuildImpl guildObj = (GuildImpl)this.api.getGuildMap().get(id);
        if (guildObj == null) {
            guildObj = new GuildImpl(this.api, id);
            this.api.getGuildMap().put(id, guildObj);
        }
        if (Helpers.optBoolean(guild, "unavailable")) {
            guildObj.setAvailable(false);
            if (secondPassCallback != null) {
                secondPassCallback.accept(guildObj);
            }
            this.api.getGuildLock().lock(id);
            return;
        }
        guildObj.setAvailable(true).setIconId(guild.optString("icon", null)).setSplashId(guild.optString("splash", null)).setRegion(guild.getString("region")).setName(guild.getString("name")).setAfkTimeout(Guild.Timeout.fromKey(guild.getInt("afk_timeout"))).setVerificationLevel(Guild.VerificationLevel.fromKey(guild.getInt("verification_level"))).setDefaultNotificationLevel(Guild.NotificationLevel.fromKey(guild.getInt("default_message_notifications"))).setRequiredMFALevel(Guild.MFALevel.fromKey(guild.getInt("mfa_level"))).setExplicitContentLevel(Guild.ExplicitContentLevel.fromKey(guild.getInt("explicit_content_filter")));
        if (guild.isNull("features")) {
            guildObj.setFeatures(Collections.emptySet());
        } else {
            guildObj.setFeatures(StreamSupport.stream(guild.getJSONArray("features").spliterator(), false).map(String::valueOf).collect(Collectors.toSet()));
        }
        JSONArray roles = guild.getJSONArray("roles");
        for (int i2 = 0; i2 < roles.length(); ++i2) {
            Role role = this.createRole(roles.getJSONObject(i2), guildObj.getIdLong());
            guildObj.getRolesMap().put(role.getIdLong(), role);
            if (role.getIdLong() != guildObj.getIdLong()) continue;
            guildObj.setPublicRole(role);
        }
        if (!guild.isNull("emojis")) {
            JSONArray array = guild.getJSONArray("emojis");
            TLongObjectMap<Emote> emoteMap = guildObj.getEmoteMap();
            for (i = 0; i < array.length(); ++i) {
                JSONObject object = array.getJSONObject(i);
                if (object.isNull("id")) {
                    LOG.error("Received GUILD_CREATE with an emoji with a null ID. JSON: {}", (Object)object);
                    continue;
                }
                JSONArray emoteRoles = object.isNull("roles") ? new JSONArray() : object.getJSONArray("roles");
                long emoteId = object.getLong("id");
                EmoteImpl emoteObj = new EmoteImpl(emoteId, guildObj);
                HashSet<Role> roleSet = emoteObj.getRoleSet();
                for (int j = 0; j < emoteRoles.length(); ++j) {
                    roleSet.add(guildObj.getRoleById(emoteRoles.getString(j)));
                }
                emoteMap.put(emoteId, emoteObj.setName(object.optString("name")).setManaged(Helpers.optBoolean(object, "managed")));
            }
        }
        if (guild.has("members")) {
            JSONArray members = guild.getJSONArray("members");
            this.createGuildMemberPass(guildObj, members);
        }
        if ((owner = guildObj.getMemberById(guild.getLong("owner_id"))) != null) {
            guildObj.setOwner(owner);
        }
        if (guild.has("presences")) {
            JSONArray presences = guild.getJSONArray("presences");
            for (i = 0; i < presences.length(); ++i) {
                JSONObject presence = presences.getJSONObject(i);
                long userId = presence.getJSONObject("user").getLong("id");
                MemberImpl member = (MemberImpl)guildObj.getMembersMap().get(userId);
                if (member == null) {
                    LOG.debug("Received a ghost presence in GuildFirstPass! UserId: {} Guild: {}", (Object)userId, (Object)guildObj);
                    continue;
                }
                this.createPresence(member, presence);
            }
        }
        if (guild.has("channels")) {
            channels = guild.getJSONArray("channels");
            block9: for (i = 0; i < channels.length(); ++i) {
                JSONObject channel = channels.getJSONObject(i);
                ChannelType type = ChannelType.fromId(channel.getInt("type"));
                switch (type) {
                    case TEXT: {
                        this.createTextChannel(channel, guildObj.getIdLong(), false);
                        continue block9;
                    }
                    case VOICE: {
                        this.createVoiceChannel(channel, guildObj.getIdLong(), false);
                        continue block9;
                    }
                    case CATEGORY: {
                        this.createCategory(channel, guildObj.getIdLong(), false);
                        continue block9;
                    }
                    default: {
                        LOG.error("Received a channel for a guild that isn't a text, voice or category channel. JSON: {}", (Object)channel);
                    }
                }
            }
        }
        if (!guild.isNull("system_channel_id")) {
            guildObj.setSystemChannel(guildObj.getTextChannelsMap().get(guild.getLong("system_channel_id")));
        }
        if (!guild.isNull("afk_channel_id")) {
            guildObj.setAfkChannel(guildObj.getVoiceChannelsMap().get(guild.getLong("afk_channel_id")));
        }
        if (guild.getJSONArray("members").length() != guild.getInt("member_count")) {
            this.cachedGuildJsons.put(id, guild);
            this.cachedGuildCallbacks.put(id, secondPassCallback);
            GuildMembersChunkHandler handler = (GuildMembersChunkHandler)this.api.getClient().getHandler("GUILD_MEMBERS_CHUNK");
            handler.setExpectedGuildMembers(id, guild.getInt("member_count"));
            if (this.api.getClient().isReady()) {
                if (this.api.getAccountType() == AccountType.CLIENT) {
                    JSONObject obj = new JSONObject().put("op", 12).put("guild_id", guildObj.getId());
                    this.api.getClient().chunkOrSyncRequest(obj);
                }
                JSONObject obj = new JSONObject().put("op", 8).put("d", new JSONObject().put("guild_id", id).put("query", "").put("limit", 0));
                this.api.getClient().chunkOrSyncRequest(obj);
            } else {
                ReadyHandler readyHandler = (ReadyHandler)this.api.getClient().getHandler("READY");
                readyHandler.acknowledgeGuild(guildObj, true, true, this.api.getAccountType() == AccountType.CLIENT);
            }
            this.api.getGuildLock().lock(id);
            return;
        }
        channels = guild.getJSONArray("channels");
        this.createGuildChannelPass(guildObj, channels);
        JSONArray voiceStates = guild.getJSONArray("voice_states");
        this.createGuildVoiceStatePass(guildObj, voiceStates);
        this.api.getGuildLock().unlock(guildObj.getIdLong());
        if (secondPassCallback != null) {
            secondPassCallback.accept(guildObj);
        }
    }

    public void createGuildSecondPass(long guildId, List<JSONArray> memberChunks) {
        JSONObject guildJson = this.cachedGuildJsons.remove(guildId);
        Consumer<Guild> secondPassCallback = this.cachedGuildCallbacks.remove(guildId);
        GuildImpl guildObj = (GuildImpl)this.api.getGuildMap().get(guildId);
        if (guildObj == null) {
            throw new IllegalStateException("Attempted to perform a second pass on an unknown Guild. Guild not in JDA mapping. GuildId: " + guildId);
        }
        if (guildJson == null) {
            throw new IllegalStateException("Attempted to perform a second pass on an unknown Guild. No cached Guild for second pass. GuildId: " + guildId);
        }
        if (secondPassCallback == null) {
            throw new IllegalArgumentException("No callback provided for the second pass on the Guild!");
        }
        for (JSONArray chunk : memberChunks) {
            this.createGuildMemberPass(guildObj, chunk);
        }
        Member owner = guildObj.getMemberById(guildJson.getLong("owner_id"));
        if (owner != null) {
            guildObj.setOwner(owner);
        }
        if (guildObj.getOwner() == null) {
            LOG.error("Never set the Owner of the Guild: {} because we don't have the owner User object! How?!", (Object)guildObj.getId());
        }
        JSONArray channels = guildJson.getJSONArray("channels");
        this.createGuildChannelPass(guildObj, channels);
        JSONArray voiceStates = guildJson.getJSONArray("voice_states");
        this.createGuildVoiceStatePass(guildObj, voiceStates);
        secondPassCallback.accept(guildObj);
        this.api.getGuildLock().unlock(guildId);
    }

    public void handleGuildSync(GuildImpl guild, JSONArray members, JSONArray presences) {
        int i;
        for (i = 0; i < members.length(); ++i) {
            JSONObject memberJson = members.getJSONObject(i);
            this.createMember(guild, memberJson);
        }
        for (i = 0; i < presences.length(); ++i) {
            JSONObject presenceJson = presences.getJSONObject(i);
            long userId = presenceJson.getJSONObject("user").getLong("id");
            MemberImpl member = (MemberImpl)guild.getMembersMap().get(userId);
            if (member == null) {
                LOG.error("Received a Presence for a non-existent Member when dealing with GuildSync!");
                continue;
            }
            this.createPresence(member, presenceJson);
        }
    }

    private void createGuildMemberPass(GuildImpl guildObj, JSONArray members) {
        for (int i = 0; i < members.length(); ++i) {
            JSONObject memberJson = members.getJSONObject(i);
            this.createMember(guildObj, memberJson);
        }
    }

    private void createGuildChannelPass(GuildImpl guildObj, JSONArray channels) {
        for (int i = 0; i < channels.length(); ++i) {
            JSONObject channel = channels.getJSONObject(i);
            ChannelType type = ChannelType.fromId(channel.getInt("type"));
            Channel channelObj = null;
            switch (type) {
                case TEXT: {
                    channelObj = this.api.getTextChannelById(channel.getLong("id"));
                    break;
                }
                case VOICE: {
                    channelObj = this.api.getVoiceChannelById(channel.getLong("id"));
                    break;
                }
                case CATEGORY: {
                    channelObj = this.api.getCategoryMap().get(channel.getLong("id"));
                    break;
                }
                default: {
                    LOG.error("Received a channel for a guild that isn't a text, voice or category channel (ChannelPass). JSON: {}", (Object)channel);
                }
            }
            if (channelObj != null) {
                JSONArray permissionOverwrites = channel.getJSONArray("permission_overwrites");
                this.createOverridesPass((AbstractChannelImpl)channelObj, permissionOverwrites);
                continue;
            }
            LOG.error("Got permission_override for unknown channel with id: {}", (Object)channel.getString("id"));
        }
    }

    public void createGuildVoiceStatePass(GuildImpl guildObj, JSONArray voiceStates) {
        for (int i = 0; i < voiceStates.length(); ++i) {
            JSONObject voiceStateJson = voiceStates.getJSONObject(i);
            long userId = voiceStateJson.getLong("user_id");
            Member member = guildObj.getMembersMap().get(userId);
            if (member == null) {
                LOG.error("Received a VoiceState for a unknown Member! GuildId: " + guildObj.getId() + " MemberId: " + voiceStateJson.getString("user_id"));
                continue;
            }
            long channelId = voiceStateJson.getLong("channel_id");
            VoiceChannelImpl voiceChannel = (VoiceChannelImpl)guildObj.getVoiceChannelsMap().get(channelId);
            if (voiceChannel != null) {
                voiceChannel.getConnectedMembersMap().put(member.getUser().getIdLong(), member);
            } else {
                LOG.error("Received a GuildVoiceState with a channel ID for a non-existent channel! ChannelId: {} GuildId: {} UserId: {}", channelId, guildObj.getId(), userId);
            }
            GuildVoiceStateImpl voiceState = (GuildVoiceStateImpl)member.getVoiceState();
            voiceState.setSelfMuted(Helpers.optBoolean(voiceStateJson, "self_mute")).setSelfDeafened(Helpers.optBoolean(voiceStateJson, "self_deaf")).setGuildMuted(Helpers.optBoolean(voiceStateJson, "mute")).setGuildDeafened(Helpers.optBoolean(voiceStateJson, "deaf")).setSuppressed(Helpers.optBoolean(voiceStateJson, "suppress")).setSessionId(voiceStateJson.optString("session_id")).setConnectedChannel(voiceChannel);
        }
    }

    public User createFakeUser(JSONObject user, boolean modifyCache) {
        return this.createUser(user, true, modifyCache);
    }

    public User createUser(JSONObject user) {
        return this.createUser(user, false, true);
    }

    private User createUser(JSONObject user, boolean fake, boolean modifyCache) {
        long id = user.getLong("id");
        UserImpl userObj = (UserImpl)this.api.getUserMap().get(id);
        if (userObj == null) {
            userObj = (UserImpl)this.api.getFakeUserMap().get(id);
            if (userObj != null) {
                if (!fake && modifyCache) {
                    this.api.getFakeUserMap().remove(id);
                    userObj.setFake(false);
                    this.api.getUserMap().put(userObj.getIdLong(), userObj);
                    if (userObj.hasPrivateChannel()) {
                        PrivateChannelImpl priv = (PrivateChannelImpl)userObj.getPrivateChannel();
                        priv.setFake(false);
                        this.api.getFakePrivateChannelMap().remove(priv.getIdLong());
                        this.api.getPrivateChannelMap().put(priv.getIdLong(), priv);
                    }
                }
            } else {
                userObj = new UserImpl(id, this.api).setFake(fake);
                if (modifyCache) {
                    if (fake) {
                        this.api.getFakeUserMap().put(id, userObj);
                    } else {
                        this.api.getUserMap().put(id, userObj);
                    }
                }
            }
        }
        return userObj.setName(user.getString("username")).setDiscriminator(user.get("discriminator").toString()).setAvatarId(user.optString("avatar", null)).setBot(Helpers.optBoolean(user, "bot"));
    }

    public Member createMember(GuildImpl guild, JSONObject memberJson) {
        User user = this.createUser(memberJson.getJSONObject("user"));
        MemberImpl member = (MemberImpl)guild.getMember(user);
        if (member == null) {
            member = new MemberImpl(guild, user);
            guild.getMembersMap().put(user.getIdLong(), member);
        }
        ((GuildVoiceStateImpl)member.getVoiceState()).setGuildMuted(memberJson.getBoolean("mute")).setGuildDeafened(memberJson.getBoolean("deaf"));
        member.setJoinDate(OffsetDateTime.parse(memberJson.getString("joined_at"))).setNickname(memberJson.optString("nick", null));
        JSONArray rolesJson = memberJson.getJSONArray("roles");
        for (int k = 0; k < rolesJson.length(); ++k) {
            long roleId = rolesJson.getLong(k);
            Role r = guild.getRolesMap().get(roleId);
            if (r == null) {
                LOG.debug("Received a Member with an unknown Role. MemberId: {} GuildId: {} roleId: {}", member.getUser().getId(), guild.getId(), roleId);
                continue;
            }
            member.getRoleSet().add(r);
        }
        return member;
    }

    public void createPresence(Object memberOrFriend, JSONObject presenceJson) {
        if (memberOrFriend == null) {
            throw new NullPointerException("Provided memberOrFriend was null!");
        }
        JSONObject gameJson = presenceJson.isNull("game") ? null : presenceJson.getJSONObject("game");
        OnlineStatus onlineStatus = OnlineStatus.fromKey(presenceJson.getString("status"));
        Game game = null;
        boolean parsedGame = false;
        if (gameJson != null && !gameJson.isNull("name")) {
            try {
                game = EntityBuilder.createGame(gameJson);
                parsedGame = true;
            }
            catch (Exception ex) {
                String userId = memberOrFriend instanceof Member ? ((Member)memberOrFriend).getUser().getId() : (memberOrFriend instanceof Friend ? ((Friend)memberOrFriend).getUser().getId() : "unknown");
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Encountered exception trying to parse a presence! UserId: {} JSON: {}", userId, gameJson, ex);
                }
                LOG.warn("Encountered exception trying to parse a presence! UserId: {} Message: {} Enable debug for details", (Object)userId, (Object)ex.getMessage());
            }
        }
        if (memberOrFriend instanceof Member) {
            MemberImpl member = (MemberImpl)memberOrFriend;
            member.setOnlineStatus(onlineStatus);
            if (parsedGame) {
                member.setGame(game);
            }
        } else if (memberOrFriend instanceof Friend) {
            FriendImpl friend = (FriendImpl)memberOrFriend;
            friend.setOnlineStatus(onlineStatus);
            if (parsedGame) {
                friend.setGame(game);
            }
            OffsetDateTime lastModified = OffsetDateTime.ofInstant(Instant.ofEpochMilli(presenceJson.getLong("last_modified")), TimeZone.getTimeZone("GMT").toZoneId());
            friend.setOnlineStatusModifiedTime(lastModified);
        } else {
            throw new IllegalArgumentException("An object was provided to EntityBuilder#createPresence that wasn't a Member or Friend. JSON: " + presenceJson);
        }
    }

    public static Game createGame(JSONObject gameJson) {
        long id;
        Game.GameType type;
        String name = String.valueOf(gameJson.get("name"));
        String url = gameJson.isNull("url") ? null : String.valueOf(gameJson.get("url"));
        try {
            type = gameJson.isNull("type") ? Game.GameType.DEFAULT : Game.GameType.fromKey(Integer.parseInt(gameJson.get("type").toString()));
        }
        catch (NumberFormatException e) {
            type = Game.GameType.DEFAULT;
        }
        try {
            id = gameJson.getLong("application_id");
        }
        catch (JSONException ex) {
            return new Game(name, url, type);
        }
        String details = gameJson.isNull("details") ? null : String.valueOf(gameJson.get("details"));
        String state = gameJson.isNull("state") ? null : String.valueOf(gameJson.get("state"));
        RichPresence.Timestamps timestamps = null;
        if (!gameJson.isNull("timestamps")) {
            JSONObject obj = gameJson.getJSONObject("timestamps");
            long start = obj.isNull("start") ? 0L : obj.getLong("start");
            long end = obj.isNull("end") ? 0L : obj.getLong("end");
            timestamps = new RichPresence.Timestamps(start, end);
        }
        RichPresence.Party party = null;
        if (!gameJson.isNull("party")) {
            JSONObject obj = gameJson.getJSONObject("party");
            String partyId = obj.isNull("id") ? null : obj.getString("id");
            JSONArray sizeArr = obj.isNull("size") ? null : obj.getJSONArray("size");
            int size = 0;
            int max = 0;
            if (sizeArr != null && sizeArr.length() > 0) {
                size = sizeArr.getInt(0);
                max = sizeArr.length() > 1 ? sizeArr.getInt(1) : 0;
            }
            party = new RichPresence.Party(partyId, size, max);
        }
        String smallImageKey = null;
        String smallImageText = null;
        String largeImageKey = null;
        String largeImageText = null;
        if (!gameJson.isNull("assets")) {
            JSONObject assets = gameJson.getJSONObject("assets");
            if (!assets.isNull("small_image")) {
                smallImageKey = String.valueOf(assets.get("small_image"));
                String string = smallImageText = assets.isNull("small_text") ? null : String.valueOf(assets.get("small_text"));
            }
            if (!assets.isNull("large_image")) {
                largeImageKey = String.valueOf(assets.get("large_image"));
                largeImageText = assets.isNull("large_text") ? null : String.valueOf(assets.get("large_text"));
            }
        }
        return new RichPresence(type, name, url, id, party, details, state, timestamps, largeImageKey, largeImageText, smallImageKey, smallImageText);
    }

    public Category createCategory(JSONObject json, long guildId) {
        return this.createCategory(json, guildId, true);
    }

    public Category createCategory(JSONObject json, long guildId, boolean guildIsLoaded) {
        long id = json.getLong("id");
        CategoryImpl channel = (CategoryImpl)this.api.getCategoryMap().get(id);
        if (channel == null) {
            GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guildId);
            channel = new CategoryImpl(id, guild);
            guild.getCategoriesMap().put(id, channel);
            this.api.getCategoryMap().put(id, channel);
        }
        if (!json.isNull("permission_overwrites") && guildIsLoaded) {
            JSONArray overrides = json.getJSONArray("permission_overwrites");
            this.createOverridesPass(channel, overrides);
        }
        return (Category)((CategoryImpl)channel.setName(json.getString("name"))).setRawPosition(json.getInt("position"));
    }

    public TextChannel createTextChannel(JSONObject json, long guildId) {
        return this.createTextChannel(json, guildId, true);
    }

    public TextChannel createTextChannel(JSONObject json, long guildId, boolean guildIsLoaded) {
        long id = json.getLong("id");
        TextChannelImpl channel = (TextChannelImpl)this.api.getTextChannelMap().get(id);
        if (channel == null) {
            GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guildId);
            channel = new TextChannelImpl(id, guild);
            guild.getTextChannelsMap().put(id, channel);
            this.api.getTextChannelMap().put(id, channel);
        }
        if (!json.isNull("permission_overwrites") && guildIsLoaded) {
            JSONArray overrides = json.getJSONArray("permission_overwrites");
            this.createOverridesPass(channel, overrides);
        }
        return ((TextChannelImpl)((TextChannelImpl)((TextChannelImpl)channel.setParent(Helpers.optLong(json, "parent_id", 0L))).setLastMessageId(Helpers.optLong(json, "last_message_id", 0L)).setName(json.getString("name"))).setTopic(json.optString("topic")).setRawPosition(json.getInt("position"))).setNSFW(Helpers.optBoolean(json, "nsfw"));
    }

    public VoiceChannel createVoiceChannel(JSONObject json, long guildId) {
        return this.createVoiceChannel(json, guildId, true);
    }

    public VoiceChannel createVoiceChannel(JSONObject json, long guildId, boolean guildIsLoaded) {
        long id = json.getLong("id");
        VoiceChannelImpl channel = (VoiceChannelImpl)this.api.getVoiceChannelMap().get(id);
        if (channel == null) {
            GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guildId);
            channel = new VoiceChannelImpl(id, guild);
            guild.getVoiceChannelsMap().put(id, channel);
            this.api.getVoiceChannelMap().put(id, channel);
        }
        if (!json.isNull("permission_overwrites") && guildIsLoaded) {
            JSONArray overrides = json.getJSONArray("permission_overwrites");
            this.createOverridesPass(channel, overrides);
        }
        return ((VoiceChannelImpl)((VoiceChannelImpl)((VoiceChannelImpl)channel.setParent(Helpers.optLong(json, "parent_id", 0L))).setName(json.getString("name"))).setRawPosition(json.getInt("position"))).setUserLimit(json.getInt("user_limit")).setBitrate(json.getInt("bitrate"));
    }

    public PrivateChannel createPrivateChannel(JSONObject privatechat) {
        JSONObject recipient = privatechat.has("recipients") ? privatechat.getJSONArray("recipients").getJSONObject(0) : privatechat.getJSONObject("recipient");
        long userId = recipient.getLong("id");
        UserImpl user = (UserImpl)this.api.getUserMap().get(userId);
        if (user == null) {
            user = (UserImpl)this.createFakeUser(recipient, true);
        }
        long channelId = privatechat.getLong("id");
        PrivateChannelImpl priv = new PrivateChannelImpl(channelId, user).setLastMessageId(Helpers.optLong(privatechat, "last_message_id", 0L));
        user.setPrivateChannel(priv);
        if (user.isFake()) {
            priv.setFake(true);
            this.api.getFakePrivateChannelMap().put(channelId, priv);
        } else {
            this.api.getPrivateChannelMap().put(channelId, priv);
        }
        return priv;
    }

    public void createOverridesPass(AbstractChannelImpl<?> channel, JSONArray overrides) {
        for (int i = 0; i < overrides.length(); ++i) {
            try {
                this.createPermissionOverride(overrides.getJSONObject(i), channel);
                continue;
            }
            catch (NoSuchElementException e) {
                LOG.debug("{}. Ignoring PermissionOverride.", (Object)e.getMessage());
                continue;
            }
            catch (IllegalArgumentException e) {
                LOG.warn("{}. Ignoring PermissionOverride.", (Object)e.getMessage());
            }
        }
    }

    public Role createRole(JSONObject roleJson, long guildId) {
        long id = roleJson.getLong("id");
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guildId);
        RoleImpl role = (RoleImpl)guild.getRolesMap().get(id);
        if (role == null) {
            role = new RoleImpl(id, guild);
            guild.getRolesMap().put(id, role);
        }
        return role.setName(roleJson.getString("name")).setRawPosition(roleJson.getInt("position")).setRawPermissions(roleJson.getLong("permissions")).setManaged(roleJson.getBoolean("managed")).setHoisted(roleJson.getBoolean("hoist")).setColor(roleJson.getInt("color") != 0 ? new Color(roleJson.getInt("color")) : null).setMentionable(roleJson.has("mentionable") && roleJson.getBoolean("mentionable"));
    }

    public Message createMessage(JSONObject jsonObject) {
        return this.createMessage(jsonObject, false);
    }

    public Message createMessage(JSONObject jsonObject, boolean exceptionOnMissingUser) {
        long channelId = jsonObject.getLong("channel_id");
        MessageChannel chan = this.api.getTextChannelById(channelId);
        if (chan == null) {
            chan = this.api.getPrivateChannelById(channelId);
        }
        if (chan == null) {
            chan = this.api.getFakePrivateChannelMap().get(channelId);
        }
        if (chan == null && this.api.getAccountType() == AccountType.CLIENT) {
            chan = this.api.asClient().getGroupById(channelId);
        }
        if (chan == null) {
            throw new IllegalArgumentException(MISSING_CHANNEL);
        }
        return this.createMessage(jsonObject, chan, exceptionOnMissingUser);
    }

    public Message createMessage(JSONObject jsonObject, MessageChannel chan, boolean exceptionOnMissingUser) {
        User user;
        long id = jsonObject.getLong("id");
        String content = jsonObject.optString("content");
        JSONObject author = jsonObject.getJSONObject("author");
        long authorId = author.getLong("id");
        boolean fromWebhook = jsonObject.has("webhook_id");
        boolean pinned = Helpers.optBoolean(jsonObject, "pinned");
        boolean tts = Helpers.optBoolean(jsonObject, "tts");
        boolean mentionsEveryone = Helpers.optBoolean(jsonObject, "mention_everyone");
        OffsetDateTime editTime = jsonObject.isNull("edited_timestamp") ? null : OffsetDateTime.parse(jsonObject.getString("edited_timestamp"));
        String nonce = jsonObject.isNull("nonce") ? null : jsonObject.get("nonce").toString();
        List<Message.Attachment> attachments = this.map(jsonObject, "attachments", this::createMessageAttachment);
        List<MessageEmbed> embeds = this.map(jsonObject, "embeds", this::createMessageEmbed);
        List<MessageReaction> reactions = this.map(jsonObject, "reactions", obj -> this.createMessageReaction(chan, id, (JSONObject)obj));
        switch (chan.getType()) {
            case PRIVATE: {
                if (authorId == this.api.getSelfUser().getIdLong()) {
                    user = this.api.getSelfUser();
                    break;
                }
                user = ((PrivateChannel)chan).getUser();
                break;
            }
            case GROUP: {
                user = this.api.getUserById(authorId);
                if (user == null) {
                    user = this.api.getFakeUserMap().get(authorId);
                }
                if (user == null && fromWebhook) {
                    user = this.createFakeUser(author, false);
                }
                if (user == null) {
                    if (exceptionOnMissingUser) {
                        throw new IllegalArgumentException(MISSING_USER);
                    }
                    user = this.createFakeUser(author, false);
                }
                if (!user.isFake() || fromWebhook) break;
                UserImpl impl = (UserImpl)user;
                impl.setName(author.getString("username")).setDiscriminator(author.get("discriminator").toString()).setAvatarId(author.optString("avatar", null)).setBot(Helpers.optBoolean(author, "bot"));
                break;
            }
            case TEXT: {
                Guild guild = ((TextChannel)chan).getGuild();
                Member member = guild.getMemberById(authorId);
                User user2 = user = member != null ? member.getUser() : null;
                if (user != null) break;
                if (fromWebhook || !exceptionOnMissingUser) {
                    user = this.createFakeUser(author, false);
                    break;
                }
                throw new IllegalArgumentException(MISSING_USER);
            }
            default: {
                throw new IllegalArgumentException("Invalid Channel for creating a Message [" + (Object)((Object)chan.getType()) + ']');
            }
        }
        MessageType type = MessageType.fromId(jsonObject.getInt("type"));
        switch (type) {
            case DEFAULT: {
                return new ReceivedMessage(id, chan, type, fromWebhook, mentionsEveryone, tts, pinned, content, nonce, user, editTime, reactions, attachments, embeds);
            }
            case UNKNOWN: {
                throw new IllegalArgumentException(UNKNOWN_MESSAGE_TYPE);
            }
        }
        return new SystemMessage(id, chan, type, fromWebhook, mentionsEveryone, tts, pinned, content, nonce, user, editTime, reactions, attachments, embeds);
    }

    public MessageReaction createMessageReaction(MessageChannel chan, long id, JSONObject obj) {
        MessageReaction.ReactionEmote reactionEmote;
        JSONObject emoji = obj.getJSONObject("emoji");
        Long emojiID = emoji.isNull("id") ? null : Long.valueOf(emoji.getLong("id"));
        String name = emoji.optString("name", null);
        int count = Helpers.optInt(obj, "count", -1);
        boolean me = Helpers.optBoolean(obj, "me");
        if (emojiID != null) {
            Emote emote = this.api.getEmoteById(emojiID);
            if (emote == null) {
                emote = new EmoteImpl((long)emojiID, this.api).setName(name);
            }
            reactionEmote = new MessageReaction.ReactionEmote(emote);
        } else {
            reactionEmote = new MessageReaction.ReactionEmote(name, null, this.api);
        }
        return new MessageReaction(chan, reactionEmote, id, me, count);
    }

    public Message.Attachment createMessageAttachment(JSONObject jsonObject) {
        int width = Helpers.optInt(jsonObject, "width", -1);
        int height = Helpers.optInt(jsonObject, "height", -1);
        int size = jsonObject.getInt("size");
        String url = jsonObject.optString("url", null);
        String proxyUrl = jsonObject.optString("proxy_url", null);
        String filename = jsonObject.getString("filename");
        long id = jsonObject.getLong("id");
        return new Message.Attachment(id, url, proxyUrl, filename, size, height, width, this.api);
    }

    public MessageEmbed createMessageEmbed(JSONObject content) {
        MessageEmbed.ImageInfo image;
        MessageEmbed.Footer footer;
        MessageEmbed.VideoInfo video;
        MessageEmbed.AuthorInfo author;
        MessageEmbed.Provider provider;
        MessageEmbed.Thumbnail thumbnail;
        Color color;
        if (content.isNull("type")) {
            throw new JSONException("Encountered embed object with missing/null type field for Json: " + content);
        }
        EmbedType type = EmbedType.fromKey(content.getString("type"));
        String url = content.optString("url", null);
        String title = content.optString("title", null);
        String description = content.optString("description", null);
        OffsetDateTime timestamp = content.isNull("timestamp") ? null : OffsetDateTime.parse(content.getString("timestamp"));
        Color color2 = color = content.isNull("color") ? null : new Color(content.getInt("color"));
        if (content.isNull("thumbnail")) {
            thumbnail = null;
        } else {
            JSONObject obj2 = content.getJSONObject("thumbnail");
            thumbnail = new MessageEmbed.Thumbnail(obj2.optString("url", null), obj2.optString("proxy_url", null), Helpers.optInt(obj2, "width", -1), Helpers.optInt(obj2, "height", -1));
        }
        if (content.isNull("provider")) {
            provider = null;
        } else {
            JSONObject obj3 = content.getJSONObject("provider");
            provider = new MessageEmbed.Provider(obj3.optString("name", null), obj3.optString("url", null));
        }
        if (content.isNull("author")) {
            author = null;
        } else {
            JSONObject obj4 = content.getJSONObject("author");
            author = new MessageEmbed.AuthorInfo(obj4.optString("name", null), obj4.optString("url", null), obj4.optString("icon_url", null), obj4.optString("proxy_icon_url", null));
        }
        if (content.isNull("video")) {
            video = null;
        } else {
            JSONObject obj5 = content.getJSONObject("video");
            video = new MessageEmbed.VideoInfo(obj5.optString("url"), Helpers.optInt(obj5, "width", -1), Helpers.optInt(obj5, "height", -1));
        }
        if (content.isNull("footer")) {
            footer = null;
        } else {
            JSONObject obj6 = content.getJSONObject("footer");
            footer = new MessageEmbed.Footer(obj6.optString("text", null), obj6.optString("icon_url", null), obj6.optString("proxy_icon_url", null));
        }
        if (content.isNull("image")) {
            image = null;
        } else {
            JSONObject obj7 = content.getJSONObject("image");
            image = new MessageEmbed.ImageInfo(obj7.optString("url", null), obj7.optString("proxy_url", null), Helpers.optInt(obj7, "width", -1), Helpers.optInt(obj7, "height", -1));
        }
        List<MessageEmbed.Field> fields = this.map(content, "fields", obj -> new MessageEmbed.Field(obj.optString("name", null), obj.optString("value", null), Helpers.optBoolean(obj, "inline"), false));
        return EntityBuilder.createMessageEmbed(url, title, description, type, timestamp, color, thumbnail, provider, author, video, footer, image, fields);
    }

    public static MessageEmbed createMessageEmbed(String url, String title, String description, EmbedType type, OffsetDateTime timestamp, Color color, MessageEmbed.Thumbnail thumbnail, MessageEmbed.Provider siteProvider, MessageEmbed.AuthorInfo author, MessageEmbed.VideoInfo videoInfo, MessageEmbed.Footer footer, MessageEmbed.ImageInfo image, List<MessageEmbed.Field> fields) {
        return new MessageEmbed(url, title, description, type, timestamp, color, thumbnail, siteProvider, author, videoInfo, footer, image, fields);
    }

    public PermissionOverride createPermissionOverride(JSONObject override, Channel chan) {
        PermissionOverrideImpl permOverride;
        long id = override.getLong("id");
        long allow = override.getLong("allow");
        long deny = override.getLong("deny");
        switch (override.getString("type")) {
            case "member": {
                Member member = chan.getGuild().getMemberById(id);
                if (member == null) {
                    throw new NoSuchElementException("Attempted to create a PermissionOverride for a non-existent user. Guild: " + chan.getGuild() + ", Channel: " + chan + ", JSON: " + override);
                }
                permOverride = (PermissionOverrideImpl)chan.getPermissionOverride(member);
                if (permOverride != null) break;
                permOverride = new PermissionOverrideImpl(chan, member.getUser().getIdLong(), member);
                ((AbstractChannelImpl)chan).getOverrideMap().put(member.getUser().getIdLong(), permOverride);
                break;
            }
            case "role": {
                Role role = ((GuildImpl)chan.getGuild()).getRolesMap().get(id);
                if (role == null) {
                    throw new NoSuchElementException("Attempted to create a PermissionOverride for a non-existent role! JSON: " + override);
                }
                permOverride = (PermissionOverrideImpl)chan.getPermissionOverride(role);
                if (permOverride != null) break;
                permOverride = new PermissionOverrideImpl(chan, role.getIdLong(), role);
                ((AbstractChannelImpl)chan).getOverrideMap().put(role.getIdLong(), permOverride);
                break;
            }
            default: {
                throw new IllegalArgumentException("Provided with an unknown PermissionOverride type! JSON: " + override);
            }
        }
        return permOverride.setAllow(allow).setDeny(deny);
    }

    public Webhook createWebhook(JSONObject object) {
        long id = object.getLong("id");
        long guildId = object.getLong("guild_id");
        long channelId = object.getLong("channel_id");
        String token = object.optString("token", null);
        TextChannel channel = this.api.getTextChannelById(channelId);
        if (channel == null) {
            throw new NullPointerException(String.format("Tried to create Webhook for an un-cached TextChannel! WebhookId: %s ChannelId: %s GuildId: %s", id, channelId, guildId));
        }
        Object name = !object.isNull("name") ? object.get("name") : JSONObject.NULL;
        Object avatar = !object.isNull("avatar") ? object.get("avatar") : JSONObject.NULL;
        JSONObject fakeUser = new JSONObject().put("username", name).put("discriminator", "0000").put("id", id).put("avatar", avatar);
        User defaultUser = this.createFakeUser(fakeUser, false);
        JSONObject ownerJson = object.getJSONObject("user");
        long userId = ownerJson.getLong("id");
        User owner = this.api.getUserById(userId);
        if (owner == null) {
            ownerJson.put("id", userId);
            owner = this.createFakeUser(ownerJson, false);
        }
        return new WebhookImpl(channel, id).setToken(token).setOwner(channel.getGuild().getMember(owner)).setUser(defaultUser);
    }

    public Relationship createRelationship(JSONObject relationshipJson) {
        if (this.api.getAccountType() != AccountType.CLIENT) {
            throw new AccountTypeException(AccountType.CLIENT, "Attempted to create a Relationship but the logged in account is not a CLIENT!");
        }
        RelationshipType type = RelationshipType.fromKey(relationshipJson.getInt("type"));
        User user = type == RelationshipType.FRIEND ? this.createUser(relationshipJson.getJSONObject("user")) : this.createFakeUser(relationshipJson.getJSONObject("user"), true);
        Relationship relationship = this.api.asClient().getRelationshipById(user.getIdLong(), type);
        if (relationship == null) {
            switch (type) {
                case FRIEND: {
                    relationship = new FriendImpl(user);
                    break;
                }
                case BLOCKED: {
                    relationship = new BlockedUserImpl(user);
                    break;
                }
                case INCOMING_FRIEND_REQUEST: {
                    relationship = new IncomingFriendRequestImpl(user);
                    break;
                }
                case OUTGOING_FRIEND_REQUEST: {
                    relationship = new OutgoingFriendRequestImpl(user);
                    break;
                }
                default: {
                    return null;
                }
            }
            this.api.asClient().getRelationshipMap().put(user.getIdLong(), relationship);
        }
        return relationship;
    }

    public Group createGroup(JSONObject groupJson) {
        if (this.api.getAccountType() != AccountType.CLIENT) {
            throw new AccountTypeException(AccountType.CLIENT, "Attempted to create a Group but the logged in account is not a CLIENT!");
        }
        long groupId = groupJson.getLong("id");
        JSONArray recipients = groupJson.getJSONArray("recipients");
        long ownerId = groupJson.getLong("owner_id");
        String name = groupJson.optString("name", null);
        String iconId = groupJson.optString("icon", null);
        long lastMessage = Helpers.optLong(groupJson, "last_message_id", 0L);
        GroupImpl group = (GroupImpl)this.api.asClient().getGroupById(groupId);
        if (group == null) {
            group = new GroupImpl(groupId, this.api);
            this.api.asClient().getGroupMap().put(groupId, group);
        }
        TLongObjectMap<User> groupUsers = group.getUserMap();
        groupUsers.put(this.api.getSelfUser().getIdLong(), this.api.getSelfUser());
        for (int i = 0; i < recipients.length(); ++i) {
            JSONObject groupUser = recipients.getJSONObject(i);
            groupUsers.put(groupUser.getLong("id"), this.createFakeUser(groupUser, true));
        }
        User owner = this.api.getUserMap().get(ownerId);
        if (owner == null) {
            owner = this.api.getFakeUserMap().get(ownerId);
        }
        if (owner == null) {
            throw new IllegalArgumentException("Attempted to build a Group, but could not find user by provided owner id.This should not be possible because the owner should be IN the group!");
        }
        return group.setOwner(owner).setLastMessageId(lastMessage).setName(name).setIconId(iconId);
    }

    public Invite createInvite(JSONObject object) {
        OffsetDateTime timeCreated;
        boolean temporary;
        int uses;
        int maxUses;
        int maxAge;
        boolean expanded;
        String code = object.getString("code");
        User inviter = object.has("inviter") ? this.createFakeUser(object.getJSONObject("inviter"), false) : null;
        JSONObject channelObject = object.getJSONObject("channel");
        ChannelType channelType = ChannelType.fromId(channelObject.getInt("type"));
        long channelId = channelObject.getLong("id");
        String channelName = channelObject.getString("name");
        InviteImpl.ChannelImpl channel = new InviteImpl.ChannelImpl(channelId, channelName, channelType);
        JSONObject guildObject = object.getJSONObject("guild");
        String guildIconId = guildObject.optString("icon", null);
        long guildId = guildObject.getLong("id");
        String guildName = guildObject.getString("name");
        String guildSplashId = guildObject.optString("splash", null);
        InviteImpl.GuildImpl guild = new InviteImpl.GuildImpl(guildId, guildIconId, guildName, guildSplashId);
        if (object.has("max_uses")) {
            expanded = true;
            maxAge = object.getInt("max_age");
            maxUses = object.getInt("max_uses");
            uses = object.getInt("uses");
            temporary = object.getBoolean("temporary");
            timeCreated = OffsetDateTime.parse(object.getString("created_at"));
        } else {
            expanded = false;
            maxAge = -1;
            maxUses = -1;
            uses = -1;
            temporary = false;
            timeCreated = null;
        }
        return new InviteImpl(this.api, code, expanded, inviter, maxAge, maxUses, temporary, timeCreated, uses, channel, guild);
    }

    public void clearCache() {
        this.cachedGuildJsons.clear();
        this.cachedGuildCallbacks.clear();
    }

    public ApplicationInfo createApplicationInfo(JSONObject object) {
        String description = object.getString("description");
        boolean doesBotRequireCodeGrant = object.getBoolean("bot_require_code_grant");
        String iconId = object.optString("icon", null);
        long id = object.getLong("id");
        String name = object.getString("name");
        boolean isBotPublic = object.getBoolean("bot_public");
        User owner = this.createFakeUser(object.getJSONObject("owner"), false);
        return new ApplicationInfoImpl(this.api, description, doesBotRequireCodeGrant, iconId, id, isBotPublic, name, owner);
    }

    public Application createApplication(JSONObject object) {
        return new ApplicationImpl(this.api, object);
    }

    public AuthorizedApplication createAuthorizedApplication(JSONObject object) {
        long authId = object.getLong("id");
        JSONArray scopeArray = object.getJSONArray("scopes");
        ArrayList<String> scopes = new ArrayList<String>(scopeArray.length());
        for (int i = 0; i < scopeArray.length(); ++i) {
            scopes.add(scopeArray.getString(i));
        }
        JSONObject application = object.getJSONObject("application");
        String description = application.getString("description");
        String iconId = application.has("icon") ? application.getString("icon") : null;
        long id = application.getLong("id");
        String name = application.getString("name");
        return new AuthorizedApplicationImpl(this.api, authId, description, iconId, id, name, scopes);
    }

    public AuditLogEntry createAuditLogEntry(GuildImpl guild, JSONObject entryJson, JSONObject userJson) {
        Set<AuditLogChange> changesList;
        long targetId = Helpers.optLong(entryJson, "target_id", 0L);
        long id = entryJson.getLong("id");
        int typeKey = entryJson.getInt("action_type");
        JSONArray changes = entryJson.isNull("changes") ? null : entryJson.getJSONArray("changes");
        JSONObject options = entryJson.isNull("options") ? null : entryJson.getJSONObject("options");
        String reason = entryJson.optString("reason", null);
        UserImpl user = (UserImpl)this.createFakeUser(userJson, false);
        ActionType type = ActionType.from(typeKey);
        if (changes != null) {
            changesList = new HashSet(changes.length());
            for (int i = 0; i < changes.length(); ++i) {
                JSONObject object = changes.getJSONObject(i);
                AuditLogChange change = this.createAuditLogChange(object);
                changesList.add(change);
            }
        } else {
            changesList = Collections.emptySet();
        }
        CaseInsensitiveMap<String, AuditLogChange> changeMap = new CaseInsensitiveMap<String, AuditLogChange>(this.changeToMap(changesList));
        CaseInsensitiveMap<String, Object> optionMap = options != null ? new CaseInsensitiveMap<String, Object>(options.toMap()) : null;
        return new AuditLogEntry(type, id, targetId, guild, user, reason, changeMap, optionMap);
    }

    public AuditLogChange createAuditLogChange(JSONObject change) {
        List<Object> newValue;
        String key = change.getString("key");
        List<Object> oldValue = change.isNull("old_value") ? null : change.get("old_value");
        List<Object> list = newValue = change.isNull("new_value") ? null : change.get("new_value");
        if (oldValue instanceof JSONArray || newValue instanceof JSONArray) {
            oldValue = oldValue instanceof JSONArray ? ((JSONArray)((Object)oldValue)).toList() : oldValue;
            newValue = newValue instanceof JSONArray ? ((JSONArray)((Object)newValue)).toList() : newValue;
        } else if (oldValue instanceof JSONObject || newValue instanceof JSONObject) {
            oldValue = oldValue instanceof JSONObject ? ((JSONObject)((Object)oldValue)).toMap() : oldValue;
            newValue = newValue instanceof JSONObject ? ((JSONObject)((Object)newValue)).toMap() : newValue;
        }
        return new AuditLogChange(oldValue, newValue, key);
    }

    private Map<String, AuditLogChange> changeToMap(Set<AuditLogChange> changesList) {
        return changesList.stream().collect(Collectors.toMap(AuditLogChange::getKey, UnaryOperator.identity()));
    }

    private <T> List<T> map(JSONObject jsonObject, String key, Function<JSONObject, T> convert) {
        if (jsonObject.isNull(key)) {
            return Collections.emptyList();
        }
        JSONArray arr = jsonObject.getJSONArray(key);
        ArrayList<T> mappedObjects = new ArrayList<T>(arr.length());
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject obj = arr.getJSONObject(i);
            mappedObjects.add(convert.apply(obj));
        }
        return mappedObjects;
    }
}

