/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.client.requests.restaction;

import net.dv8tion.jda.client.entities.Application;
import net.dv8tion.jda.core.entities.Icon;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import okhttp3.RequestBody;
import org.json.JSONObject;

public class ApplicationAction
extends RestAction<Application> {
    protected String description = null;
    protected Icon icon = null;
    protected String name = null;

    public ApplicationAction(JDAImpl api, String name) {
        super(api, Route.Applications.CREATE_APPLICATION.compile(new String[0]));
        this.setName(name);
    }

    @Override
    protected RequestBody finalizeData() {
        JSONObject object = new JSONObject();
        object.put("name", this.name);
        if (this.description != null && !this.description.isEmpty()) {
            object.put("description", this.description);
        }
        if (this.icon != null) {
            object.put("icon", this.icon.getEncoding());
        }
        return this.getRequestBody(object);
    }

    @Override
    protected void handleResponse(Response response, Request<Application> request) {
        if (response.isOk()) {
            request.onSuccess(this.api.getEntityBuilder().createApplication(response.getObject()));
        } else {
            request.onFailure(response);
        }
    }

    public ApplicationAction setDescription(String description) {
        if (description != null && description.length() > 400) {
            throw new IllegalArgumentException("The description must not be more than 400 characters!");
        }
        this.description = description;
        return this;
    }

    public ApplicationAction setIcon(Icon icon) {
        this.icon = icon;
        return this;
    }

    public ApplicationAction setName(String name) {
        if (name == null || name.length() < 2 || name.length() > 32) {
            throw new IllegalArgumentException("The application name must not be null and in the range of 2-32!");
        }
        this.name = name;
        return this;
    }
}

