/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.bot.sharding;

import com.neovisionaries.ws.client.WebSocketFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.bot.sharding.DefaultShardManager;
import net.dv8tion.jda.bot.sharding.ShardManager;
import net.dv8tion.jda.core.OnlineStatus;
import net.dv8tion.jda.core.ShardedRateLimiter;
import net.dv8tion.jda.core.audio.factory.IAudioSendFactory;
import net.dv8tion.jda.core.entities.Game;
import net.dv8tion.jda.core.hooks.IEventManager;
import net.dv8tion.jda.core.utils.Checks;
import okhttp3.OkHttpClient;

public class DefaultShardManagerBuilder {
    protected final List<Object> listeners = new ArrayList<Object>();
    protected IntFunction<ConcurrentMap<String, String>> contextProvider = null;
    protected boolean enableContext = true;
    protected boolean enableBulkDeleteSplitting = true;
    protected boolean enableShutdownHook = true;
    protected boolean enableVoice = true;
    protected boolean autoReconnect = true;
    protected boolean retryOnTimeout = true;
    protected boolean useShutdownNow = false;
    protected int shardsTotal = -1;
    protected int maxReconnectDelay = 900;
    protected int corePoolSize = 2;
    protected String token = null;
    protected IntFunction<Boolean> idleProvider = null;
    protected IntFunction<Game> gameProvider = null;
    protected IntFunction<OnlineStatus> statusProvider = null;
    protected Collection<Integer> shards = null;
    protected IEventManager eventManager = null;
    protected ShardedRateLimiter shardedRateLimiter = null;
    protected OkHttpClient.Builder httpClientBuilder = null;
    protected WebSocketFactory wsFactory = null;
    protected IAudioSendFactory audioSendFactory = null;
    protected ThreadFactory threadFactory = null;

    public DefaultShardManagerBuilder setContextMap(IntFunction<ConcurrentMap<String, String>> provider) {
        this.contextProvider = provider;
        if (provider != null) {
            this.enableContext = true;
        }
        return this;
    }

    public DefaultShardManagerBuilder setContextEnabled(boolean enable) {
        this.enableContext = enable;
        return this;
    }

    public DefaultShardManagerBuilder addEventListeners(Object ... listeners) {
        return this.addEventListeners(Arrays.asList(listeners));
    }

    public DefaultShardManagerBuilder addEventListeners(Collection<Object> listeners) {
        Checks.noneNull(listeners, "listeners");
        this.listeners.addAll(listeners);
        return this;
    }

    public DefaultShardManagerBuilder removeEventListeners(Object ... listeners) {
        return this.removeEventListeners(Arrays.asList(listeners));
    }

    public DefaultShardManagerBuilder removeEventListeners(Collection<Object> listeners) {
        Checks.noneNull(listeners, "listeners");
        this.listeners.removeAll(listeners);
        return this;
    }

    public DefaultShardManagerBuilder setAudioEnabled(boolean enabled) {
        this.enableVoice = enabled;
        return this;
    }

    public DefaultShardManagerBuilder setAudioSendFactory(IAudioSendFactory factory) {
        this.audioSendFactory = factory;
        return this;
    }

    public DefaultShardManagerBuilder setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        return this;
    }

    public DefaultShardManagerBuilder setBulkDeleteSplittingEnabled(boolean enabled) {
        this.enableBulkDeleteSplitting = enabled;
        return this;
    }

    public DefaultShardManagerBuilder setCorePoolSize(int size) {
        Checks.positive(size, "Core pool size");
        this.corePoolSize = size;
        return this;
    }

    public DefaultShardManagerBuilder setEnableShutdownHook(boolean enable) {
        this.enableShutdownHook = enable;
        return this;
    }

    public DefaultShardManagerBuilder setEventManager(IEventManager manager) {
        Checks.notNull(manager, "manager");
        this.eventManager = manager;
        return this;
    }

    public DefaultShardManagerBuilder setGame(Game game) {
        return this.setGameProvider(id -> game);
    }

    public DefaultShardManagerBuilder setGameProvider(IntFunction<Game> gameProvider) {
        this.gameProvider = gameProvider;
        return this;
    }

    public DefaultShardManagerBuilder setIdle(boolean idle) {
        return this.setIdleProvider(id -> idle);
    }

    public DefaultShardManagerBuilder setIdleProvider(IntFunction<Boolean> idleProvider) {
        this.idleProvider = idleProvider;
        return this;
    }

    public DefaultShardManagerBuilder setStatus(OnlineStatus status) {
        Checks.notNull((Object)status, "status");
        Checks.check(status != OnlineStatus.UNKNOWN, "OnlineStatus cannot be unknown!");
        return this.setStatusProvider(id -> status);
    }

    public DefaultShardManagerBuilder setStatusProvider(IntFunction<OnlineStatus> statusProvider) {
        this.statusProvider = statusProvider;
        return this;
    }

    public DefaultShardManagerBuilder setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public DefaultShardManagerBuilder setHttpClientBuilder(OkHttpClient.Builder builder) {
        this.httpClientBuilder = builder;
        return this;
    }

    public DefaultShardManagerBuilder setMaxReconnectDelay(int maxReconnectDelay) {
        Checks.check(maxReconnectDelay >= 32, "Max reconnect delay must be 32 seconds or greater. You provided %d.", (Object)maxReconnectDelay);
        this.maxReconnectDelay = maxReconnectDelay;
        return this;
    }

    public DefaultShardManagerBuilder setRequestTimeoutRetry(boolean retryOnTimeout) {
        this.retryOnTimeout = retryOnTimeout;
        return this;
    }

    public DefaultShardManagerBuilder setShardedRateLimiter(ShardedRateLimiter shardedRateLimiter) {
        Checks.notNull(shardedRateLimiter, "shardedRateLimiter");
        this.shardedRateLimiter = shardedRateLimiter;
        return this;
    }

    public DefaultShardManagerBuilder setShards(int ... shardIds) {
        Checks.notNull(shardIds, "shardIds");
        for (int id : shardIds) {
            Checks.notNegative(id, "minShardId");
            Checks.check(id < this.shardsTotal, "maxShardId must be lower than shardsTotal");
        }
        this.shards = Arrays.stream(shardIds).boxed().collect(Collectors.toSet());
        return this;
    }

    public DefaultShardManagerBuilder setShards(int minShardId, int maxShardId) {
        Checks.notNegative(minShardId, "minShardId");
        Checks.check(maxShardId < this.shardsTotal, "maxShardId must be lower than shardsTotal");
        Checks.check(minShardId <= maxShardId, "minShardId must be lower than or equal to maxShardId");
        ArrayList<Integer> shards = new ArrayList<Integer>(maxShardId - minShardId + 1);
        for (int i = minShardId; i <= maxShardId; ++i) {
            shards.add(i);
        }
        this.shards = shards;
        return this;
    }

    public DefaultShardManagerBuilder setShards(Collection<Integer> shardIds) {
        Checks.notNull(shardIds, "shardIds");
        for (Integer id : this.shards) {
            Checks.notNegative(id, "minShardId");
            Checks.check(id < this.shardsTotal, "maxShardId must be lower than shardsTotal");
        }
        this.shards = new ArrayList<Integer>(shardIds);
        return this;
    }

    public DefaultShardManagerBuilder setShardsTotal(int shardsTotal) {
        Checks.check(shardsTotal == -1 || shardsTotal > 0, "shardsTotal must either be -1 or greater than 0");
        this.shardsTotal = shardsTotal;
        return this;
    }

    public DefaultShardManagerBuilder setToken(String token) {
        Checks.notBlank(token, "token");
        this.token = token;
        return this;
    }

    public DefaultShardManagerBuilder setUseShutdownNow(boolean useShutdownNow) {
        this.useShutdownNow = useShutdownNow;
        return this;
    }

    public DefaultShardManagerBuilder setWebsocketFactory(WebSocketFactory factory) {
        this.wsFactory = factory;
        return this;
    }

    public ShardManager build() throws LoginException, IllegalArgumentException {
        DefaultShardManager manager = new DefaultShardManager(this.shardsTotal, this.shards, this.listeners, this.token, this.eventManager, this.audioSendFactory, this.gameProvider, this.statusProvider, this.httpClientBuilder, this.wsFactory, this.threadFactory, this.shardedRateLimiter, this.maxReconnectDelay, this.corePoolSize, this.enableVoice, this.enableShutdownHook, this.enableBulkDeleteSplitting, this.autoReconnect, this.idleProvider, this.retryOnTimeout, this.useShutdownNow, this.enableContext, this.contextProvider);
        manager.login();
        return manager;
    }
}

