/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.bot.sharding;

import com.neovisionaries.ws.client.WebSocketFactory;
import gnu.trove.map.TIntObjectMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.bot.sharding.ShardManager;
import net.dv8tion.jda.bot.utils.cache.ShardCacheView;
import net.dv8tion.jda.bot.utils.cache.impl.ShardCacheViewImpl;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.OnlineStatus;
import net.dv8tion.jda.core.ShardedRateLimiter;
import net.dv8tion.jda.core.audio.factory.IAudioSendFactory;
import net.dv8tion.jda.core.entities.Game;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.exceptions.RateLimitedException;
import net.dv8tion.jda.core.hooks.IEventManager;
import net.dv8tion.jda.core.managers.impl.PresenceImpl;
import net.dv8tion.jda.core.requests.SessionReconnectQueue;
import net.dv8tion.jda.core.requests.WebSocketClient;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.JDALogger;
import net.dv8tion.jda.core.utils.tuple.Pair;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;

public class DefaultShardManager
implements ShardManager {
    public static final Logger LOG = JDALogger.getLog(ShardManager.class);
    public static final ThreadFactory DEFAULT_THREAD_FACTORY = r -> {
        Thread t = new Thread(r, "DefaultShardManager");
        t.setDaemon(true);
        t.setPriority(6);
        return t;
    };
    protected final IAudioSendFactory audioSendFactory;
    protected final boolean autoReconnect;
    protected final int corePoolSize;
    protected final boolean enableBulkDeleteSplitting;
    protected final boolean enableVoice;
    protected final IEventManager eventManager;
    protected final List<Object> listeners;
    protected final int maxReconnectDelay;
    protected final ScheduledExecutorService executor;
    protected final Queue<Integer> queue = new ConcurrentLinkedQueue<Integer>();
    protected final SessionReconnectQueue sessionReconnectQueue = this.createReconnectQueue();
    protected ShardCacheViewImpl shards;
    protected int shardsTotal;
    protected final OkHttpClient.Builder httpClientBuilder;
    protected final WebSocketFactory wsFactory;
    protected final boolean retryOnTimeout;
    protected final boolean useShutdownNow;
    protected final ShardedRateLimiter shardedRateLimiter;
    protected final AtomicBoolean shutdown = new AtomicBoolean(false);
    protected final Thread shutdownHook;
    protected final String token;
    protected ScheduledFuture<?> worker;
    protected String gatewayURL;
    protected IntFunction<Game> gameProvider;
    protected IntFunction<Boolean> idleProvider;
    protected IntFunction<OnlineStatus> statusProvider;
    protected IntFunction<ConcurrentMap<String, String>> contextProvider;
    protected boolean enableMDC;

    protected DefaultShardManager(int shardsTotal, Collection<Integer> shardIds, List<Object> listeners, String token, IEventManager eventManager, IAudioSendFactory audioSendFactory, IntFunction<Game> gameProvider, IntFunction<OnlineStatus> statusProvider, OkHttpClient.Builder httpClientBuilder, WebSocketFactory wsFactory, ThreadFactory threadFactory, ShardedRateLimiter shardedRateLimiter, int maxReconnectDelay, int corePoolSize, boolean enableVoice, boolean enableShutdownHook, boolean enableBulkDeleteSplitting, boolean autoReconnect, IntFunction<Boolean> idleProvider, boolean retryOnTimeout, boolean useShutdownNow, boolean enableMDC, IntFunction<ConcurrentMap<String, String>> contextProvider) {
        this.shardsTotal = shardsTotal;
        this.listeners = listeners;
        this.token = token;
        this.eventManager = eventManager;
        this.audioSendFactory = audioSendFactory;
        this.gameProvider = gameProvider;
        this.statusProvider = statusProvider;
        this.httpClientBuilder = httpClientBuilder == null ? new OkHttpClient.Builder() : httpClientBuilder;
        this.wsFactory = wsFactory == null ? new WebSocketFactory() : wsFactory;
        this.executor = this.createExecutor(threadFactory);
        this.shardedRateLimiter = shardedRateLimiter == null ? new ShardedRateLimiter() : shardedRateLimiter;
        this.maxReconnectDelay = maxReconnectDelay;
        this.corePoolSize = corePoolSize;
        this.enableVoice = enableVoice;
        this.shutdownHook = enableShutdownHook ? new Thread(this::shutdown, "JDA Shutdown Hook") : null;
        this.enableBulkDeleteSplitting = enableBulkDeleteSplitting;
        this.autoReconnect = autoReconnect;
        this.idleProvider = idleProvider;
        this.retryOnTimeout = retryOnTimeout;
        this.useShutdownNow = useShutdownNow;
        this.contextProvider = contextProvider;
        this.enableMDC = enableMDC;
        if (shardsTotal != -1) {
            if (shardIds == null) {
                this.shards = new ShardCacheViewImpl(shardsTotal);
                for (int i = 0; i < this.shardsTotal; ++i) {
                    this.queue.add(i);
                }
            } else {
                this.shards = new ShardCacheViewImpl(shardIds.size());
                shardIds.stream().distinct().sorted().forEach(this.queue::add);
            }
        }
    }

    @Override
    public void addEventListener(Object ... listeners) {
        ShardManager.super.addEventListener(listeners);
        Collections.addAll(this.listeners, listeners);
    }

    @Override
    public void removeEventListener(Object ... listeners) {
        ShardManager.super.removeEventListener(listeners);
        this.listeners.removeAll(Arrays.asList(listeners));
    }

    @Override
    public int getShardsQueued() {
        return this.queue.size();
    }

    @Override
    public ShardCacheView getShardCache() {
        return this.shards;
    }

    public void login() throws LoginException, IllegalArgumentException {
        JDAImpl jda = null;
        try {
            int shardId = this.queue.isEmpty() ? 0 : this.queue.peek();
            jda = this.buildInstance(shardId);
            this.shards.getMap().put(shardId, jda);
            this.queue.remove(shardId);
        }
        catch (RateLimitedException shardId) {
        }
        catch (Exception e) {
            if (jda != null) {
                if (this.useShutdownNow) {
                    jda.shutdownNow();
                } else {
                    jda.shutdown();
                }
            }
            throw e;
        }
        this.worker = this.executor.scheduleWithFixedDelay(this::processQueue, 5000L, 5000L, TimeUnit.MILLISECONDS);
        if (this.shutdownHook != null) {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    @Override
    public void restart(int shardId) {
        Checks.notNegative(shardId, "shardId");
        Checks.check(shardId < this.shardsTotal, "shardId must be lower than shardsTotal");
        JDA jda = this.shards.getMap().remove(shardId);
        if (jda != null) {
            if (this.useShutdownNow) {
                jda.shutdownNow();
            } else {
                jda.shutdown();
            }
        }
        this.queue.add(shardId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restart() {
        TIntObjectMap<JDA> map;
        TIntObjectMap<JDA> tIntObjectMap = map = this.shards.getMap();
        synchronized (tIntObjectMap) {
            Arrays.stream(map.keys()).sorted().forEach(id -> {
                JDA jda = (JDA)map.remove(id);
                if (jda != null) {
                    if (this.useShutdownNow) {
                        jda.shutdownNow();
                    } else {
                        jda.shutdown();
                    }
                }
                this.queue.add(id);
            });
        }
    }

    @Override
    public void shutdown() {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.executor.shutdown();
        if (this.shards != null) {
            for (JDA jda : this.shards) {
                if (this.useShutdownNow) {
                    jda.shutdownNow();
                    continue;
                }
                jda.shutdown();
            }
        }
    }

    @Override
    public void shutdown(int shardId) {
        JDA jda = this.shards.getMap().remove(shardId);
        if (jda != null) {
            if (this.useShutdownNow) {
                jda.shutdownNow();
            } else {
                jda.shutdown();
            }
        }
    }

    @Override
    public void start(int shardId) {
        Checks.notNegative(shardId, "shardId");
        Checks.check(shardId < this.shardsTotal, "shardId must be lower than shardsTotal");
        this.queue.add(shardId);
    }

    protected void processQueue() {
        int shardId;
        if (this.shards == null) {
            shardId = 0;
        } else {
            Integer tmp = this.queue.peek();
            int n = shardId = tmp == null ? -1 : tmp;
        }
        if (shardId == -1) {
            return;
        }
        JDAImpl api = null;
        try {
            JDAImpl jDAImpl = api = this.shards == null ? null : (JDAImpl)this.shards.getElementById(shardId);
            if (api == null) {
                api = this.buildInstance(shardId);
            } else if (api.getStatus() == JDA.Status.RECONNECT_QUEUED) {
                api.getClient().reconnect(true, true);
            }
        }
        catch (RateLimitedException e) {
            LOG.warn("Hit the login ratelimit while creating new JDA instances");
        }
        catch (LoginException e) {
            LOG.warn("The token has been invalidated and the ShardManager will shutdown!", e);
            this.shutdown();
        }
        catch (Exception e) {
            LOG.error("Caught an exception in the queue processing thread", e);
        }
        this.shards.getMap().put(shardId, api);
        this.queue.remove(shardId);
    }

    protected JDAImpl buildInstance(int shardId) throws LoginException, RateLimitedException {
        JDAImpl jda = new JDAImpl(AccountType.BOT, this.token, this.httpClientBuilder, this.wsFactory, this.shardedRateLimiter, this.autoReconnect, this.enableVoice, false, this.enableBulkDeleteSplitting, this.retryOnTimeout, this.enableMDC, this.corePoolSize, this.maxReconnectDelay, this.contextProvider == null || !this.enableMDC ? null : this.contextProvider.apply(shardId));
        jda.asBot().setShardManager(this);
        if (this.eventManager != null) {
            jda.setEventManager(this.eventManager);
        }
        if (this.audioSendFactory != null) {
            jda.setAudioSendFactory(this.audioSendFactory);
        }
        this.listeners.forEach(xva$0 -> jda.addEventListener(xva$0));
        jda.setStatus(JDA.Status.INITIALIZED);
        PresenceImpl presence = (PresenceImpl)jda.getPresence();
        if (this.gameProvider != null) {
            presence.setCacheGame(this.gameProvider.apply(shardId));
        }
        if (this.idleProvider != null) {
            presence.setCacheIdle(this.idleProvider.apply(shardId));
        }
        if (this.statusProvider != null) {
            presence.setCacheStatus(this.statusProvider.apply(shardId));
        }
        if (this.gatewayURL == null) {
            try {
                Pair<String, Integer> gateway = jda.getGatewayBot().complete();
                this.gatewayURL = gateway.getLeft();
                if (this.shardsTotal == -1) {
                    this.shardsTotal = gateway.getRight();
                    this.shards = new ShardCacheViewImpl(this.shardsTotal);
                    for (int i = 0; i < this.shardsTotal; ++i) {
                        this.queue.add(i);
                    }
                }
            }
            catch (RuntimeException e) {
                Throwable ex;
                Throwable throwable = ex = e.getCause() instanceof ExecutionException ? e.getCause().getCause() : null;
                if (ex instanceof LoginException) {
                    throw new LoginException(ex.getMessage());
                }
                throw e;
            }
        }
        JDA.ShardInfo shardInfo = new JDA.ShardInfo(shardId, this.shardsTotal);
        int shardTotal = jda.login(this.gatewayURL, shardInfo, this.sessionReconnectQueue);
        if (this.shardsTotal == -1) {
            this.shardsTotal = shardTotal;
        }
        JDA.Status waitUntil = JDA.Status.AWAITING_LOGIN_CONFIRMATION;
        while (!jda.getStatus().isInit() || jda.getStatus().ordinal() < waitUntil.ordinal()) {
            if (jda.getStatus() == JDA.Status.SHUTDOWN) {
                throw new IllegalStateException("JDA was unable to finish starting up!");
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return jda;
    }

    @Override
    public void setGameProvider(IntFunction<Game> gameProvider) {
        ShardManager.super.setGameProvider(gameProvider);
        this.gameProvider = gameProvider;
    }

    @Override
    public void setIdleProvider(IntFunction<Boolean> idleProvider) {
        ShardManager.super.setIdleProvider(idleProvider);
        this.idleProvider = idleProvider;
    }

    @Override
    public void setStatusProvider(IntFunction<OnlineStatus> statusProvider) {
        ShardManager.super.setStatusProvider(statusProvider);
        this.statusProvider = statusProvider;
    }

    protected ScheduledExecutorService createExecutor(ThreadFactory threadFactory) {
        ThreadFactory factory = threadFactory == null ? DEFAULT_THREAD_FACTORY : threadFactory;
        return Executors.newSingleThreadScheduledExecutor(factory);
    }

    protected SessionReconnectQueue createReconnectQueue() {
        return new ForwardingSessionReconnectQueue(jda -> this.queue.add(jda.getShardInfo().getShardId()), jda -> this.queue.remove(jda.getShardInfo().getShardId()));
    }

    public class ForwardingSessionReconnectQueue
    extends SessionReconnectQueue {
        private final Consumer<JDA> appender;
        private final Consumer<JDA> remover;

        public ForwardingSessionReconnectQueue(Consumer<JDA> appender, Consumer<JDA> remover) {
            super(null);
            this.appender = appender == null ? jda -> {} : appender;
            this.remover = remover == null ? jda -> {} : remover;
        }

        @Override
        protected void appendSession(WebSocketClient client) {
            this.appender.accept(client.getJDA());
        }

        @Override
        protected void removeSession(WebSocketClient client) {
            this.remover.accept(client.getJDA());
        }

        @Override
        protected void runWorker() {
        }
    }
}

