/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.retrieve;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Role;
import org.bukkit.event.Event;

public class ExprRoleWithId
extends SimpleExpression<Role> {
    private Expression<String> id;
    private Expression<Guild> guild;

    protected Role[] get(Event e) {
        if (this.guild.getSingle(e) == null) {
            Skript.error((String)"You must include a guild to get the role from!");
            return null;
        }
        Guild guild = (Guild)this.guild.getSingle(e);
        if (this.id.getSingle(e) == null) {
            Skript.error((String)"You must include a ID to find the Role by!");
            return null;
        }
        String id = (String)this.id.getSingle(e);
        if (guild.getRoleById(id) == null) {
            Skript.error((String)"Could not find role with that ID in the provided Guild");
            return null;
        }
        try {
            return new Role[]{guild.getRoleById(id)};
        }
        catch (IllegalArgumentException x) {
            Skript.error((String)"You must include a ID to find the Role by!");
            return null;
        }
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Role> getReturnType() {
        return Role.class;
    }

    public String toString(Event e, boolean debug) {
        return "role with id " + this.id.toString(e, debug) + " in " + this.guild.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.id = exprs[0];
        this.guild = exprs[1];
        return true;
    }

    static {
        Vixio.getInstance().registerExpression(ExprRoleWithId.class, Role.class, ExpressionType.SIMPLE, "role with id %string% [in %guild%]").setName("Role with ID").setDesc("Get a Role via it's ID, plain and simple.").setExample("Coming Soon!");
    }
}

