/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.retrieve;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Set;
import me.iblitzkriegi.vixio.Vixio;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.VoiceChannel;
import org.bukkit.event.Event;

public class ExprChannelWithId
extends SimpleExpression<Channel> {
    private Expression<String> id;
    private Expression<Guild> guild;

    protected Channel[] get(Event event) {
        return new Channel[]{this.getChannel(event)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Channel> getReturnType() {
        return Channel.class;
    }

    public String toString(Event e, boolean b) {
        return this.guild != null ? "channel with id " + this.id.toString(e, b) + " in guild " + this.guild.toString(e, b) : "channel with id " + this.id.toString(e, b);
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.id = expressions[0];
        this.guild = expressions[1];
        return true;
    }

    private Channel getChannel(Event e) {
        if (this.id == null) {
            Skript.error((String)"You must include a ID to use to find a channel!");
            return null;
        }
        String id = (String)this.id.getSingle(e);
        if (this.guild == null) {
            Set<JDA> jdaInstances = Vixio.getInstance().botHashMap.keySet();
            if (jdaInstances == null) {
                Skript.error((String)"You must first login to a bot to use this syntax.");
                return null;
            }
            for (JDA jDA : jdaInstances) {
                TextChannel textChannel = jDA.getTextChannelById(id);
                VoiceChannel voiceChannel = jDA.getVoiceChannelById(id);
                if (textChannel != null) {
                    return textChannel;
                }
                if (voiceChannel == null) continue;
                return voiceChannel;
            }
            Skript.error((String)"Could not find channel via that ID");
            return null;
        }
        Guild guild = (Guild)this.guild.getSingle(e);
        for (TextChannel textChannel : guild.getTextChannels()) {
            if (!textChannel.getId().equalsIgnoreCase(id)) continue;
            return textChannel;
        }
        for (VoiceChannel voiceChannel : guild.getVoiceChannels()) {
            if (!voiceChannel.getId().equalsIgnoreCase(id)) continue;
            return voiceChannel;
        }
        Skript.error((String)"Could not find channel via that ID");
        return null;
    }

    static {
        Vixio.getInstance().registerExpression(ExprChannelWithId.class, Channel.class, ExpressionType.SIMPLE, "[(voice|text)][(-| )]channel with id %string% [in %-guild%]").setName("Channel with ID").setDesc("Get a Text or Voice channel via it's ID.").setExample("");
    }
}

