/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.message.builder;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import net.dv8tion.jda.core.MessageBuilder;
import org.bukkit.event.Event;

public class ExprTextOfBuilder
extends SimplePropertyExpression<MessageBuilder, String> {
    private boolean stripped;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.setExpr(exprs[0]);
        this.stripped = parseResult.regexes.size() == 1;
        return true;
    }

    protected String getPropertyName() {
        return "[<stripped>] text of messagebuilders";
    }

    public String convert(MessageBuilder messageBuilder) {
        if (this.stripped) {
            try {
                return messageBuilder.build().getContentStripped();
            }
            catch (UnsupportedOperationException x) {
                Skript.error((String)"You may not get the stripped content of a Message that was created with a Message Builder.");
            }
        } else {
            return messageBuilder.isEmpty() ? null : messageBuilder.build().getContentRaw();
        }
        return null;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if ((mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) && this.getExpr().isSingle()) {
            return new Class[]{String.class};
        }
        return super.acceptChange(mode);
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        MessageBuilder builder = (MessageBuilder)this.getExpr().getSingle(e);
        if (builder == null) {
            return;
        }
        switch (mode) {
            case RESET: 
            case DELETE: {
                builder.setContent(null);
                break;
            }
            case SET: {
                builder.setContent((String)delta[0]);
            }
        }
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        return "the text of " + this.getExpr().toString(e, debug);
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprTextOfBuilder.class, String.class, "[<stripped>] text", "messagebuilders").setName("Text of Message Builder").setDesc("Get the text inside of a Message Builder").setExample("command /build:", "\ttrigger:", "\t\tset {e} to a new message builder", "\t\tset text of {e} to \"Hey look at this\"", "\t\tbroadcast \"%text of {e}%\"");
    }
}

