/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.guild;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.Util;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.exceptions.PermissionException;
import org.bukkit.event.Event;

public class ExprRolesOfMember
extends SimpleExpression<Role> {
    Expression<Member> member;
    Expression<Object> bot;

    protected Role[] get(Event e) {
        if (this.member.getAll(e) == null) {
            Skript.error((String)"You, must input a Member, to get the roles of..");
            return null;
        }
        ArrayList roles = new ArrayList();
        Arrays.stream(this.member.getAll(e)).filter(Objects::nonNull).forEach(member -> roles.addAll(member.getRoles()));
        return roles.toArray(new Role[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Role> getReturnType() {
        return Role.class;
    }

    public String toString(Event e, boolean debug) {
        return "roles of " + this.member.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.member = exprs[0];
        this.bot = exprs[1];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if ((mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD) && this.member.isSingle()) {
            return new Class[]{Role[].class};
        }
        return super.acceptChange(mode);
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Role role = (Role)delta[0];
        if (this.bot.getSingle(e) == null) {
            Skript.error((String)"You must input a bot to modify roles.");
            return;
        }
        Object object = this.bot.getSingle(e);
        Member member = (Member)this.member.getSingle(e);
        if (member == null) {
            Skript.error((String)"You must input a Member to modify their roles.");
            return;
        }
        Guild guild = role.getGuild();
        try {
            switch (mode) {
                case REMOVE: 
                case ADD: {
                    Bot bot = Util.botFrom(object);
                    if (bot == null) {
                        Skript.error((String)"Could not parse provided bot. Please input either a %bot% or the string name you gave to your bot with the login effect!");
                        return;
                    }
                    if (delta.length == 1) {
                        if (Util.botIsConnected(bot, guild.getJDA())) {
                            guild.getController().addSingleRoleToMember(member, (Role)delta[0]).queue();
                            return;
                        }
                        bot.getJDA().getGuildById(guild.getId()).getController().addSingleRoleToMember(member, (Role)delta[0]).queue();
                        return;
                    }
                    ArrayList<Role> roles = new ArrayList<Role>();
                    for (int i = 0; i < delta.length; ++i) {
                        roles.add((Role)delta[i]);
                    }
                    if (Util.botIsConnected(bot, guild.getJDA())) {
                        guild.getController().addRolesToMember(member, roles).queue();
                        return;
                    }
                    bot.getJDA().getGuildById(guild.getId()).getController().addRolesToMember(member, roles).queue();
                }
            }
        }
        catch (PermissionException x) {
            Skript.error((String)"Provided bot does not have enough permission to execute the requested action.");
        }
    }

    static {
        Vixio.getInstance().registerExpression(ExprRolesOfMember.class, Role.class, ExpressionType.SIMPLE, "role[s] of %members% [as %bot/string%]").setName("Roles of Member").setDesc("Get the roles that a Member has in a Guild").setExample("Coming Soon!");
    }
}

