/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.embeds;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.Title;
import net.dv8tion.jda.core.EmbedBuilder;
import net.dv8tion.jda.core.entities.MessageEmbed;
import org.bukkit.event.Event;

public class ExprTitleOfEmbed
extends SimplePropertyExpression<EmbedBuilder, Title> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.setExpr(exprs[0]);
        return true;
    }

    public Title convert(EmbedBuilder embed) {
        if (embed.isEmpty()) {
            return null;
        }
        MessageEmbed builtEmbed = embed.build();
        return new Title(builtEmbed.getTitle(), builtEmbed.getUrl());
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if ((mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) && this.getExpr().isSingle()) {
            return new Class[]{Title.class};
        }
        return super.acceptChange(mode);
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        EmbedBuilder embed = (EmbedBuilder)this.getExpr().getSingle(e);
        if (embed == null) {
            return;
        }
        switch (mode) {
            case RESET: 
            case DELETE: {
                embed.setTitle(null);
                return;
            }
            case SET: {
                Title title = (Title)delta[0];
                embed.setTitle(title.getText(), title.getUrl());
            }
        }
    }

    public Class<? extends Title> getReturnType() {
        return Title.class;
    }

    protected String getPropertyName() {
        return "title of embed";
    }

    public String toString(Event e, boolean debug) {
        return "the title of " + this.getExpr().toString(e, debug);
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprTitleOfEmbed.class, Title.class, "title[s]", "embedbuilders").setName("Title of Embed").setDesc("Returns the title of an embed.").setExample("set the embed title of {_embed} to title with text \"hey this is a cool title!\" and no icon");
    }
}

