/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.embeds;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import net.dv8tion.jda.core.EmbedBuilder;
import net.dv8tion.jda.core.entities.MessageEmbed;
import org.bukkit.event.Event;

public class ExprThumbnailOfEmbed
extends SimplePropertyExpression<EmbedBuilder, MessageEmbed.Thumbnail> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.setExpr(exprs[0]);
        return true;
    }

    public MessageEmbed.Thumbnail convert(EmbedBuilder embed) {
        return embed.isEmpty() ? null : embed.build().getThumbnail();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if ((mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) && this.getExpr().isSingle()) {
            return new Class[]{String.class};
        }
        return super.acceptChange(mode);
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        EmbedBuilder embed = (EmbedBuilder)this.getExpr().getSingle(e);
        if (embed == null) {
            return;
        }
        switch (mode) {
            case RESET: 
            case DELETE: {
                embed.setThumbnail(null);
                return;
            }
            case SET: {
                String url = (String)delta[0];
                try {
                    embed.setThumbnail(url);
                    break;
                }
                catch (IllegalArgumentException e1) {
                    Skript.error((String)("Vixio encountered the error \"" + e1.getMessage() + "\" while trying to set the thumbnail of " + this.getExpr().toString(e, false) + " to \"" + url + "\""));
                }
            }
        }
    }

    public Class<? extends MessageEmbed.Thumbnail> getReturnType() {
        return MessageEmbed.Thumbnail.class;
    }

    protected String getPropertyName() {
        return "thumbnail of embed";
    }

    public String toString(Event e, boolean debug) {
        return "the thumbnail of " + this.getExpr().toString(e, debug);
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprThumbnailOfEmbed.class, MessageEmbed.Thumbnail.class, "(thumbnail|icon)[s]", "embedbuilders").setName("Thumbnail of Embed").setDesc("Returns the thumbnail of an embed. Can be set to any string (e.g. \"https://i.imgur.com/TQgR2hW.jpg\").").setExample("set the thumbnail of {_embed} to \"https://i.imgur.com/TQgR2hW.jpg\"");
    }
}

