/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.embeds;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import net.dv8tion.jda.core.EmbedBuilder;
import net.dv8tion.jda.core.entities.MessageEmbed;
import org.bukkit.event.Event;

public class ExprImageOfEmbed
extends SimplePropertyExpression<EmbedBuilder, MessageEmbed.ImageInfo> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.setExpr(exprs[0]);
        return true;
    }

    public MessageEmbed.ImageInfo convert(EmbedBuilder embed) {
        return embed.isEmpty() ? null : embed.build().getImage();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if ((mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) && this.getExpr().isSingle()) {
            return new Class[]{String.class};
        }
        return super.acceptChange(mode);
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        EmbedBuilder embed = (EmbedBuilder)this.getExpr().getSingle(e);
        if (embed == null) {
            return;
        }
        switch (mode) {
            case RESET: 
            case DELETE: {
                embed.setImage(null);
                return;
            }
            case SET: {
                String url = (String)delta[0];
                try {
                    embed.setImage(url);
                    break;
                }
                catch (IllegalArgumentException e1) {
                    Skript.error((String)("Vixio encountered the error \"" + e1.getMessage() + "\" while trying to set the image of " + this.getExpr().toString(e, false) + " to \"" + url + "\""));
                }
            }
        }
    }

    public Class<? extends MessageEmbed.ImageInfo> getReturnType() {
        return MessageEmbed.ImageInfo.class;
    }

    protected String getPropertyName() {
        return "image of embed";
    }

    public String toString(Event e, boolean debug) {
        return "the image of " + this.getExpr().toString(e, debug);
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprImageOfEmbed.class, MessageEmbed.ImageInfo.class, "image[s]", "embedbuilders").setName("Image of Embed").setDesc("Returns the image of an embed. Can be set any url (e.g. \"https://i.imgur.com/TQgR2hW.jpg\").").setExample("set the image of {_embed} to \"https://i.imgur.com/TQgR2hW.jpg\"");
    }
}

