/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.embeds;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.awt.Color;
import java.lang.reflect.Field;
import me.iblitzkriegi.vixio.Vixio;
import net.dv8tion.jda.core.EmbedBuilder;
import org.bukkit.event.Event;

public class ExprColorOfEmbed
extends SimplePropertyExpression<EmbedBuilder, Color> {
    private static Field COLOR_FIELD;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.setExpr(exprs[0]);
        return COLOR_FIELD != null;
    }

    public Color convert(EmbedBuilder embed) {
        if (embed.isEmpty()) {
            Color color = null;
            try {
                color = (Color)COLOR_FIELD.get(embed);
            }
            catch (IllegalAccessException e) {
                Skript.exception((Throwable)e, (String[])new String[0]);
            }
            return color;
        }
        return embed.build().getColor();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if ((mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) && this.getExpr().isSingle()) {
            return new Class[]{Color.class};
        }
        return super.acceptChange(mode);
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        EmbedBuilder embed = (EmbedBuilder)this.getExpr().getSingle(e);
        if (embed == null) {
            return;
        }
        switch (mode) {
            case RESET: 
            case DELETE: {
                embed.setColor(null);
                return;
            }
            case SET: {
                embed.setColor((Color)delta[0]);
            }
        }
    }

    public Class<? extends Color> getReturnType() {
        return Color.class;
    }

    protected String getPropertyName() {
        return "color of embed";
    }

    public String toString(Event e, boolean debug) {
        return "the color of embed " + this.getExpr().toString(e, debug);
    }

    static {
        try {
            COLOR_FIELD = EmbedBuilder.class.getDeclaredField("color");
            COLOR_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            Skript.error((String)"Vixio couldn't find the color field in the EmbedBuilder class");
        }
        Vixio.getInstance().registerPropertyExpression(ExprColorOfEmbed.class, Color.class, "colo[u]r[s]", "embedbuilders").setName("Color of Embed").setDesc("Returns the color of an embed. Can be set to any color (e.g. red).").setExample("set discord color of {_embed} to red");
    }
}

