/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.embeds;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import net.dv8tion.jda.core.EmbedBuilder;
import net.dv8tion.jda.core.entities.MessageEmbed;
import org.bukkit.event.Event;

public class ExprAuthorOfEmbed
extends SimplePropertyExpression<EmbedBuilder, MessageEmbed.AuthorInfo> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.setExpr(exprs[0]);
        return true;
    }

    public MessageEmbed.AuthorInfo convert(EmbedBuilder embed) {
        return embed.isEmpty() ? null : embed.build().getAuthor();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if ((mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) && this.getExpr().isSingle()) {
            return new Class[]{MessageEmbed.AuthorInfo.class};
        }
        return super.acceptChange(mode);
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        EmbedBuilder embed = (EmbedBuilder)this.getExpr().getSingle(e);
        if (embed == null) {
            return;
        }
        switch (mode) {
            case RESET: 
            case DELETE: {
                embed.setAuthor(null, null, null);
                break;
            }
            case SET: {
                MessageEmbed.AuthorInfo author = (MessageEmbed.AuthorInfo)delta[0];
                embed.setAuthor(author.getName(), author.getUrl(), author.getIconUrl());
            }
        }
    }

    public Class<? extends MessageEmbed.AuthorInfo> getReturnType() {
        return MessageEmbed.AuthorInfo.class;
    }

    protected String getPropertyName() {
        return "author of embed";
    }

    public String toString(Event e, boolean debug) {
        return "the author of " + this.getExpr().toString(e, debug);
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprAuthorOfEmbed.class, MessageEmbed.AuthorInfo.class, "(author info|author)[s]", "embedbuilders").setName("Author of Embed").setDesc("Returns the author of an embed. Can be set to any author.").setExample("set author of {_embed} to author named \"Pikachu\"");
    }
}

