/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.channel;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.exceptions.PermissionException;
import org.bukkit.event.Event;

public class ExprTopicOfChannel
extends SimpleExpression<String> {
    private Expression<TextChannel> channel;
    private Expression<Bot> bot;

    protected String[] get(Event event) {
        TextChannel channel = (TextChannel)this.channel.getSingle(event);
        if (channel == null) {
            return null;
        }
        return new String[]{channel.getTopic()};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event event, boolean b) {
        return "topic of " + this.channel.toString(event, b) + (this.bot == null ? "" : " as " + this.bot.toString(event, b));
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.channel = expressions[0];
        this.bot = expressions[1];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return new Class[]{String.class};
        }
        return super.acceptChange(mode);
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (this.bot.getSingle(e) != null) {
            JDA jda = ((Bot)this.bot.getSingle(e)).getJDA();
            if (jda != null) {
                if (this.channel.getSingle(e) != null) {
                    TextChannel channel = jda.getTextChannelById(((TextChannel)this.channel.getSingle(e)).getId());
                    try {
                        switch (mode) {
                            case RESET: 
                            case DELETE: {
                                channel.getManager().setTopic(null).queue();
                                break;
                            }
                            case SET: {
                                channel.getManager().setTopic((String)delta[0]).queue();
                            }
                        }
                    }
                    catch (PermissionException x) {
                        Skript.error((String)"Provided bot does not have enough permission to modify the topic of the provided channel");
                    }
                } else {
                    Skript.error((String)"Provided bot could not find provided channel.");
                }
            } else {
                Skript.error((String)"Could not find stored bot by the stored bot.");
            }
        } else {
            Skript.error((String)"You must include a bot in order to modify the topic!");
        }
    }

    static {
        Vixio.getInstance().registerExpression(ExprTopicOfChannel.class, String.class, ExpressionType.SIMPLE, "topic of %channel% [(with|as) %-bot%]").setName("Topic of Channel").setDesc("Get/Reset/Set the topic of a channel. Must include a bot to modify the topic!").setExample("set topic of event-channel as event-bot to \"Hi Pika\"");
    }
}

