/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.wrapper.Bot;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.exceptions.PermissionException;
import org.bukkit.event.Event;

public class ExprDiscordNameOf
extends SimplePropertyExpression<Object, String> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.setExpr(exprs[0]);
        return true;
    }

    protected String getPropertyName() {
        return "name of";
    }

    public String convert(Object o) {
        if (o instanceof User) {
            return ((User)o).getName();
        }
        if (o instanceof Guild) {
            return ((Guild)o).getName();
        }
        if (o instanceof Channel) {
            return ((Channel)o).getName();
        }
        if (o instanceof Member) {
            return ((Member)o).getUser().getName();
        }
        if (o instanceof Bot) {
            return ((Bot)o).getName();
        }
        if (o instanceof Role) {
            return ((Role)o).getName();
        }
        Skript.error((String)"Could not parse provided argument, please refer to the syntax.");
        return null;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET && this.getExpr().isSingle()) {
            return new Class[]{String.class};
        }
        return super.acceptChange(mode);
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Object object = this.getExpr().getSingle(e);
        if (object instanceof Member || object instanceof User) {
            return;
        }
        switch (mode) {
            case SET: {
                if (object instanceof Bot) {
                    Bot bot = (Bot)object;
                    bot.getSelfUser().getManager().setName((String)delta[0]).queue();
                    break;
                }
                if (object instanceof Channel) {
                    Channel channel = (Channel)object;
                    try {
                        channel.getManager().setName((String)delta[0]).queue();
                    }
                    catch (PermissionException x) {
                        Skript.error((String)"Bot does not have proper permission to change the name of the provided text channel.");
                    }
                    break;
                }
                if (!(object instanceof Guild)) break;
                Guild guild = (Guild)object;
                try {
                    guild.getManager().setName((String)delta[0]).queue();
                    break;
                }
                catch (PermissionException x) {
                    Skript.error((String)"Bot does not have proper permission to change the name of the provided guild.");
                }
            }
        }
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        Vixio.getInstance().registerPropertyExpression(ExprDiscordNameOf.class, String.class, "name", "channel/guild/user/member/bot/role").setName("Name of").setDesc("Get the name of something/someone. There is a SET changer for channel,guild, and bot.").setExample("name of event-user");
    }
}

