/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.effects.message;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.expressions.message.ExprLastRetrievedMessage;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.TextChannel;
import org.bukkit.event.Event;

public class EffRetrieveMessage
extends Effect {
    Expression<String> id;
    Expression<TextChannel> channel;

    protected void execute(Event e) {
        if (this.id.getSingle(e) == null) {
            Skript.error((String)"You must include a ID in order to retrieve a Message");
            return;
        }
        String id = (String)this.id.getSingle(e);
        if (this.channel.getSingle(e) == null) {
            Skript.error((String)"You must include a Text Channel in order to retrieve the Message from it.");
            return;
        }
        Channel channel = (Channel)this.channel.getSingle(e);
        if (channel.getType().equals((Object)ChannelType.TEXT)) {
            TextChannel textChannel = (TextChannel)channel;
            textChannel.getMessageById(id).queue(message -> {
                ExprLastRetrievedMessage.lastRetrievedMessage = message;
            });
            return;
        }
        Skript.error((String)"Provided channel was not a text channel.");
    }

    public String toString(Event event, boolean b) {
        return "retrieve message with id " + this.id.toString(event, b) + " from channel " + this.channel.toString(event, b);
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.id = expressions[0];
        this.channel = expressions[1];
        return true;
    }

    static {
        Vixio.getInstance().registerEffect(EffRetrieveMessage.class, "retrieve message with id %string% from %channel%").setName("Retrieve message with id").setDesc("Get a Message via it's ID from a Guild/TextChannel").setExample("retrieve message with id \"1265152161551661561\" from channel event-channel");
    }
}

