/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.tools.io;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;

public class HttpInterface
implements Closeable {
    private final CloseableHttpClient client;
    private final HttpClientContext context;
    private final boolean ownedClient;
    private HttpUriRequest lastRequest;
    private boolean available;

    public HttpInterface(CloseableHttpClient client, HttpClientContext context, boolean ownedClient) {
        this.client = client;
        this.context = context;
        this.ownedClient = ownedClient;
        this.available = true;
    }

    public boolean acquire() {
        if (!this.available) {
            return false;
        }
        this.available = false;
        return true;
    }

    public CloseableHttpResponse execute(HttpUriRequest request) throws IOException {
        this.lastRequest = request;
        return this.client.execute(request, this.context);
    }

    public URI getFinalLocation() {
        List<URI> redirectLocations = this.context.getRedirectLocations();
        if (redirectLocations != null && redirectLocations.size() > 0) {
            return redirectLocations.get(redirectLocations.size() - 1);
        }
        return this.lastRequest != null ? this.lastRequest.getURI() : null;
    }

    public HttpClientContext getContext() {
        return this.context;
    }

    @Override
    public void close() throws IOException {
        this.available = true;
        if (this.ownedClient) {
            this.client.close();
        }
    }
}

