/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.tools;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.NameValuePair;

public class DataFormatTools {
    private static final Pattern lineSplitPattern = Pattern.compile("[\\r\\n\\s]*\\n[\\r\\n\\s]*");

    public static String extractBetween(String haystack, String start, String end) {
        int startPosition;
        int endPosition;
        int startMatch = haystack.indexOf(start);
        if (startMatch >= 0 && (endPosition = haystack.indexOf(end, startPosition = startMatch + start.length())) >= 0) {
            return haystack.substring(startPosition, endPosition);
        }
        return null;
    }

    public static Map<String, String> convertToMapLayout(Collection<NameValuePair> pairs) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (NameValuePair pair : pairs) {
            map.put(pair.getName(), pair.getValue());
        }
        return map;
    }

    public static <T> T defaultOnNull(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static String[] streamToLines(InputStream inputStream, Charset charset) throws IOException {
        String text = IOUtils.toString(inputStream, charset);
        return lineSplitPattern.split(text);
    }

    public static long durationTextToMillis(String durationText) {
        int length = 0;
        for (String part : durationText.split(":")) {
            length = length * 60 + Integer.valueOf(part);
        }
        return (long)length * 1000L;
    }

    public static void writeNullableText(DataOutput output, String text) throws IOException {
        output.writeBoolean(text != null);
        if (text != null) {
            output.writeUTF(text);
        }
    }

    public static String readNullableText(DataInput input) throws IOException {
        boolean exists = input.readBoolean();
        return exists ? input.readUTF() : null;
    }
}

