/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.DaemonThreadFactory;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.ExecutorTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeMixProvider {
    private static final Logger log = LoggerFactory.getLogger(YoutubeMixProvider.class);
    private static final int MIX_QUEUE_CAPACITY = 5000;
    private final YoutubeAudioSourceManager sourceManager;
    private final ExecutorService mixLoadingExecutor;

    public YoutubeMixProvider(YoutubeAudioSourceManager sourceManager) {
        this.sourceManager = sourceManager;
        this.mixLoadingExecutor = new ThreadPoolExecutor(0, 10, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(5000), new DaemonThreadFactory("yt-mix"));
    }

    public void shutdown() {
        ExecutorTools.shutdownExecutor(this.mixLoadingExecutor, "youtube mix");
    }

    public AudioPlaylist loadMixWithId(String mixId, String selectedVideoId) {
        ArrayList<String> videoIds = new ArrayList<String>();
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            String mixUrl = "https://www.youtube.com/watch?v=" + selectedVideoId + "&list=" + mixId;
            try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(mixUrl));){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    throw new IOException("Invalid status code for mix response: " + statusCode);
                }
                Document document = Jsoup.parse(response.getEntity().getContent(), StandardCharsets.UTF_8.name(), "");
                this.extractVideoIdsFromMix(document, videoIds);
            }
        }
        catch (IOException e) {
            throw new FriendlyException("Could not read mix page.", FriendlyException.Severity.SUSPICIOUS, e);
        }
        if (videoIds.isEmpty()) {
            throw new FriendlyException("Could not find tracks from mix.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        return this.loadTracksAsynchronously(videoIds, selectedVideoId);
    }

    private void extractVideoIdsFromMix(Document document, List<String> videoIds) {
        for (Element videoList : document.select("#playlist-autoscroll-list")) {
            for (Element item : videoList.select("li")) {
                videoIds.add(item.attr("data-video-id"));
            }
        }
    }

    private AudioPlaylist loadTracksAsynchronously(List<String> videoIds, String selectedVideoId) {
        ExecutorCompletionService<AudioItem> completion = new ExecutorCompletionService<AudioItem>(this.mixLoadingExecutor);
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (String videoId : videoIds) {
            completion.submit(() -> this.sourceManager.loadTrackWithVideoId(videoId, true));
        }
        try {
            this.fetchTrackResultsFromExecutor(completion, tracks, videoIds.size());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        AudioTrack selectedTrack = this.sourceManager.findSelectedTrack(tracks, selectedVideoId);
        if (tracks.isEmpty()) {
            throw new FriendlyException("No tracks from the mix loaded succesfully.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        if (selectedTrack == null) {
            throw new FriendlyException("The selected track of the mix failed to load.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        return new BasicAudioPlaylist("YouTube mix", tracks, selectedTrack, false);
    }

    private void fetchTrackResultsFromExecutor(ExecutorCompletionService<AudioItem> completion, List<AudioTrack> tracks, int size) throws InterruptedException {
        for (int i = 0; i < size; ++i) {
            try {
                AudioItem item = completion.take().get();
                if (!(item instanceof AudioTrack)) continue;
                tracks.add((AudioTrack)item);
                continue;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof FriendlyException) {
                    ExceptionTools.log(log, (FriendlyException)e.getCause(), "Loading a track from a mix.");
                    continue;
                }
                log.warn("Failed to load a track from a mix.", e);
            }
        }
    }
}

