/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.twitch;

import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamAudioTrack;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class TwitchStreamAudioSourceManager
implements AudioSourceManager,
HttpConfigurable {
    private static final String STREAM_NAME_REGEX = "^https://(?:www\\.|go\\.)?twitch.tv/([^/]+)$";
    private static final Pattern streamNameRegex = Pattern.compile("^https://(?:www\\.|go\\.)?twitch.tv/([^/]+)$");
    public static final String CLIENT_ID = "jzkbprff40iqj646a697cyrvl0zt2m6";
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();

    @Override
    public String getSourceName() {
        return "twitch";
    }

    @Override
    public AudioItem loadItem(DefaultAudioPlayerManager manager, AudioReference reference) {
        String streamName = TwitchStreamAudioSourceManager.getChannelIdentifierFromUrl(reference.identifier);
        if (streamName == null) {
            return null;
        }
        JsonBrowser channelInfo = this.fetchStreamChannelInfo(streamName);
        if (channelInfo == null) {
            return AudioReference.NO_TRACK;
        }
        String displayName = channelInfo.get("display_name").text();
        String status = channelInfo.get("status").text();
        return new TwitchStreamAudioTrack(new AudioTrackInfo(status, displayName, Long.MAX_VALUE, reference.identifier, true, reference.identifier), this);
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) throws IOException {
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        return new TwitchStreamAudioTrack(trackInfo, this);
    }

    public static String getChannelIdentifierFromUrl(String url) {
        Matcher matcher = streamNameRegex.matcher(url);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }

    public static HttpUriRequest createGetRequest(String url) {
        return TwitchStreamAudioSourceManager.addClientHeaders(new HttpGet(url));
    }

    public static HttpUriRequest createGetRequest(URI url) {
        return TwitchStreamAudioSourceManager.addClientHeaders(new HttpGet(url));
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    private static HttpUriRequest addClientHeaders(HttpUriRequest request) {
        request.setHeader("Client-ID", CLIENT_ID);
        return request;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonBrowser fetchStreamChannelInfo(String name) {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            HttpUriRequest request = TwitchStreamAudioSourceManager.createGetRequest("https://api.twitch.tv/api/channels/" + name + "/ember?on_site=1");
            JsonBrowser jsonBrowser = HttpClientTools.fetchResponseAsJson(httpInterface, request);
            return jsonBrowser;
        }
        catch (IOException e) {
            throw new FriendlyException("Loading Twitch channel information failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    @Override
    public void shutdown() {
    }
}

