/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.http;

import com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.http.HttpAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(HttpAudioTrack.class);
    private final MediaContainerProbe probe;
    private final HttpAudioSourceManager sourceManager;

    public HttpAudioTrack(AudioTrackInfo trackInfo, MediaContainerProbe probe, HttpAudioSourceManager sourceManager) {
        super(trackInfo);
        this.probe = probe;
        this.sourceManager = sourceManager;
    }

    public MediaContainerProbe getProbe() {
        return this.probe;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            log.debug("Starting http track from URL: {}", (Object)this.trackInfo.identifier);
            try (PersistentHttpStream inputStream = new PersistentHttpStream(httpInterface, new URI(this.trackInfo.identifier), Long.MAX_VALUE);){
                this.processDelegate((InternalAudioTrack)this.probe.createTrack(this.trackInfo, inputStream), localExecutor);
            }
        }
    }

    @Override
    public AudioTrack makeClone() {
        return new HttpAudioTrack(this.trackInfo, this.probe, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

