/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.bandcamp;

import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.bandcamp.BandcampAudioTrack;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;

public class BandcampAudioSourceManager
implements AudioSourceManager,
HttpConfigurable {
    private static final String TRACK_URL_REGEX = "^https?://(?:[^.]+\\.|)bandcamp\\.com/track/([a-zA-Z0-9-_]+)/?(?:\\?.*|)$";
    private static final String ALBUM_URL_REGEX = "^https?://(?:[^.]+\\.|)bandcamp\\.com/album/([a-zA-Z0-9-_]+)/?(?:\\?.*|)$";
    private static final Pattern trackUrlPattern = Pattern.compile("^https?://(?:[^.]+\\.|)bandcamp\\.com/track/([a-zA-Z0-9-_]+)/?(?:\\?.*|)$");
    private static final Pattern albumUrlPattern = Pattern.compile("^https?://(?:[^.]+\\.|)bandcamp\\.com/album/([a-zA-Z0-9-_]+)/?(?:\\?.*|)$");
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();

    @Override
    public String getSourceName() {
        return "bandcamp";
    }

    @Override
    public AudioItem loadItem(DefaultAudioPlayerManager manager, AudioReference reference) {
        if (trackUrlPattern.matcher(reference.identifier).matches()) {
            return this.loadTrack(reference.identifier);
        }
        if (albumUrlPattern.matcher(reference.identifier).matches()) {
            return this.loadAlbum(reference.identifier);
        }
        return null;
    }

    private AudioItem loadTrack(String trackUrl) {
        return this.extractFromPage(trackUrl, (httpClient, text) -> {
            String bandUrl = this.readBandUrl(text);
            JsonBrowser trackListInfo = this.readTrackListInformation(text);
            String artist = trackListInfo.get("artist").text();
            return this.extractTrack(trackListInfo.get("trackinfo").index(0), bandUrl, artist);
        });
    }

    private AudioItem loadAlbum(String albumUrl) {
        return this.extractFromPage(albumUrl, (httpClient, text) -> {
            String bandUrl = this.readBandUrl(text);
            JsonBrowser trackListInfo = this.readTrackListInformation(text);
            String artist = trackListInfo.get("artist").text();
            ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
            for (JsonBrowser trackInfo : trackListInfo.get("trackinfo").values()) {
                tracks.add(this.extractTrack(trackInfo, bandUrl, artist));
            }
            JsonBrowser albumInfo = this.readAlbumInformation(text);
            return new BasicAudioPlaylist(albumInfo.get("album_title").text(), tracks, null, false);
        });
    }

    private AudioTrack extractTrack(JsonBrowser trackInfo, String bandUrl, String artist) {
        String trackPageUrl = bandUrl + trackInfo.get("title_link").text();
        return new BandcampAudioTrack(new AudioTrackInfo(trackInfo.get("title").text(), artist, (long)(trackInfo.get("duration").as(Double.class) * 1000.0), bandUrl + trackInfo.get("title_link").text(), false, trackPageUrl), this);
    }

    private String readBandUrl(String text) {
        String bandUrl = DataFormatTools.extractBetween(text, "var band_url = \"", "\";");
        if (bandUrl == null) {
            throw new FriendlyException("Band information not found on the Bandcamp page.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        return bandUrl;
    }

    private JsonBrowser readAlbumInformation(String text) throws IOException {
        String albumInfoJson = DataFormatTools.extractBetween(text, "var EmbedData = ", "};");
        if (albumInfoJson == null) {
            throw new FriendlyException("Album information not found on the Bandcamp page.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        albumInfoJson = albumInfoJson.replace("\" + \"", "") + "};";
        return JsonBrowser.parse(albumInfoJson);
    }

    JsonBrowser readTrackListInformation(String text) throws IOException {
        String trackInfoJson = DataFormatTools.extractBetween(text, "var TralbumData = ", "};");
        if (trackInfoJson == null) {
            throw new FriendlyException("Track information not found on the Bandcamp page.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        trackInfoJson = trackInfoJson.replace("\" + \"", "") + "};";
        return JsonBrowser.parse(trackInfoJson + "};");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AudioItem extractFromPage(String url, AudioItemExtractor extractor) {
        try (HttpInterface httpInterface = this.httpInterfaceManager.getInterface();){
            AudioItem audioItem = this.extractFromPageWithInterface(httpInterface, url, extractor);
            return audioItem;
        }
        catch (Exception e) {
            throw ExceptionTools.wrapUnfriendlyExceptions("Loading information for a Bandcamp track failed.", FriendlyException.Severity.FAULT, e);
        }
    }

    private AudioItem extractFromPageWithInterface(HttpInterface httpInterface, String url, AudioItemExtractor extractor) throws Exception {
        String responseText;
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(url));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 404) {
                AudioReference audioReference = new AudioReference(null, null);
                return audioReference;
            }
            if (statusCode != 200) {
                throw new IOException("Invalid status code for track page: " + statusCode);
            }
            responseText = IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8);
        }
        return extractor.extract(httpInterface, responseText);
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) throws IOException {
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        return new BandcampAudioTrack(trackInfo, this);
    }

    @Override
    public void shutdown() {
        IOUtils.closeQuietly((Closeable)this.httpInterfaceManager);
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    private static interface AudioItemExtractor {
        public AudioItem extract(HttpInterface var1, String var2) throws Exception;
    }
}

