/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.format;

public class AudioDataFormat {
    private static final byte[] SILENT_OPUS_FRAME = new byte[]{-4, -1, -2};
    public final int channelCount;
    public final int sampleRate;
    public final int chunkSampleCount;
    public final Codec codec;
    public final byte[] silence;

    public AudioDataFormat(int channelCount, int sampleRate, int chunkSampleCount, Codec codec) {
        this.channelCount = channelCount;
        this.sampleRate = sampleRate;
        this.chunkSampleCount = chunkSampleCount;
        this.codec = codec;
        this.silence = this.produceSilence();
    }

    public int bufferSize(int sampleSize) {
        return this.chunkSampleCount * this.channelCount * sampleSize;
    }

    public long frameDuration() {
        return (long)this.chunkSampleCount * 1000L / (long)this.sampleRate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioDataFormat that = (AudioDataFormat)o;
        if (this.channelCount != that.channelCount) {
            return false;
        }
        if (this.sampleRate != that.sampleRate) {
            return false;
        }
        if (this.chunkSampleCount != that.chunkSampleCount) {
            return false;
        }
        return this.codec == that.codec;
    }

    public int hashCode() {
        int result = this.channelCount;
        result = 31 * result + this.sampleRate;
        result = 31 * result + this.chunkSampleCount;
        result = 31 * result + this.codec.hashCode();
        return result;
    }

    private byte[] produceSilence() {
        if (this.codec == Codec.OPUS) {
            return SILENT_OPUS_FRAME;
        }
        return new byte[this.bufferSize(2)];
    }

    public static enum Codec {
        OPUS,
        PCM_S16_LE,
        PCM_S16_BE;

    }
}

