/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.wav;

import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import com.sedmelluq.discord.lavaplayer.container.wav.WavAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.wav.WavFileInfo;
import com.sedmelluq.discord.lavaplayer.container.wav.WavFileLoader;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WavContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(WavContainerProbe.class);

    @Override
    public String getName() {
        return "wav";
    }

    @Override
    public boolean matchesHints(MediaContainerHints hints) {
        return false;
    }

    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream inputStream) throws IOException {
        if (!MediaContainerDetection.checkNextBytes(inputStream, WavFileLoader.WAV_RIFF_HEADER)) {
            return null;
        }
        log.debug("Track {} is a WAV file.", (Object)reference.identifier);
        WavFileInfo fileInfo = new WavFileLoader(inputStream).parseHeaders();
        return new MediaContainerDetectionResult((MediaContainerProbe)this, new AudioTrackInfo(DataFormatTools.defaultOnNull(reference.title, "Unknown title"), "Unknown artist", fileInfo.getDuration(), reference.identifier, false, reference.identifier));
    }

    @Override
    public AudioTrack createTrack(AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        return new WavAudioTrack(trackInfo, inputStream);
    }
}

