/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.adts;

import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import com.sedmelluq.discord.lavaplayer.container.adts.AdtsAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.adts.AdtsStreamReader;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdtsContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(AdtsContainerProbe.class);

    @Override
    public String getName() {
        return "adts";
    }

    @Override
    public boolean matchesHints(MediaContainerHints hints) {
        return false;
    }

    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream inputStream) throws IOException {
        AdtsStreamReader reader = new AdtsStreamReader(inputStream);
        if (reader.findPacketHeader(1000) == null) {
            return null;
        }
        log.debug("Track {} is an ADTS stream.", (Object)reference.identifier);
        return new MediaContainerDetectionResult((MediaContainerProbe)this, new AudioTrackInfo(reference.title != null ? reference.title : "Unknown title", "Unknown artist", Long.MAX_VALUE, reference.identifier, true, reference.identifier));
    }

    @Override
    public AudioTrack createTrack(AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        return new AdtsAudioTrack(trackInfo, inputStream);
    }
}

