/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import net.dv8tion.jda.core.utils.Helpers;

public class SimpleLog {
    public static Level LEVEL = Level.INFO;
    public static boolean ENABLE_GUI = false;
    private static final String FORMAT = "[%time%] [%level%] [%name%]: %text%";
    private static final String MSGFORMAT = "%text%";
    private static final SimpleDateFormat DFORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final Map<String, SimpleLog> LOGS = new HashMap<String, SimpleLog>();
    private static final Set<LogListener> listeners = new HashSet<LogListener>();
    private static final Map<Level, Set<File>> fileLogs = new HashMap<Level, Set<File>>();
    private static PrintStream origStd = null;
    private static PrintStream origErr = null;
    private static FileOutputStream stdOut = null;
    private static FileOutputStream errOut = null;
    public final String name;
    private Level level = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleLog getLog(String name) {
        Map<String, SimpleLog> map = LOGS;
        synchronized (map) {
            if (!LOGS.containsKey(name.toLowerCase())) {
                LOGS.put(name.toLowerCase(), new SimpleLog(name));
            }
        }
        return LOGS.get(name.toLowerCase());
    }

    public static void addFileLogs(File std, File err) throws IOException {
        FileOutputStream fOut;
        if (std != null) {
            if (origStd == null) {
                origStd = System.out;
            }
            if (!std.getAbsoluteFile().getParentFile().exists()) {
                std.getAbsoluteFile().getParentFile().mkdirs();
            }
            if (!std.exists()) {
                std.createNewFile();
            }
            fOut = new FileOutputStream(std, true);
            System.setOut(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    origStd.write(b);
                    fOut.write(b);
                }
            }));
            if (stdOut != null) {
                stdOut.close();
            }
            stdOut = fOut;
        } else if (origStd != null) {
            System.setOut(origStd);
            stdOut.close();
            origStd = null;
        }
        if (err != null) {
            if (origErr == null) {
                origErr = System.err;
            }
            if (!err.getAbsoluteFile().getParentFile().exists()) {
                err.getAbsoluteFile().getParentFile().mkdirs();
            }
            if (!err.exists()) {
                err.createNewFile();
            }
            fOut = new FileOutputStream(err, true);
            System.setErr(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    origErr.write(b);
                    fOut.write(b);
                }
            }));
            if (errOut != null) {
                errOut.close();
            }
            errOut = fOut;
        } else if (origErr != null) {
            System.setErr(origErr);
            errOut.close();
            origErr = null;
        }
    }

    public static void addFileLog(Level logLevel, File file) throws IOException {
        File canonicalFile = file.getCanonicalFile();
        if (!fileLogs.containsKey((Object)logLevel)) {
            fileLogs.put(logLevel, new HashSet());
        }
        fileLogs.get((Object)logLevel).add(canonicalFile);
    }

    public static void removeFileLog(Level logLevel) {
        fileLogs.remove((Object)logLevel);
    }

    public static void removeFileLog(File file) throws IOException {
        File canonicalFile = file.getCanonicalFile();
        Iterator<Map.Entry<Level, Set<File>>> setIter = fileLogs.entrySet().iterator();
        while (setIter.hasNext()) {
            Map.Entry<Level, Set<File>> set = setIter.next();
            Iterator<File> fileIter = set.getValue().iterator();
            while (fileIter.hasNext()) {
                File logFile = fileIter.next();
                if (!logFile.equals(canonicalFile)) continue;
                fileIter.remove();
                break;
            }
            if (!set.getValue().isEmpty()) continue;
            setIter.remove();
        }
    }

    private static Set<File> collectFiles(Level level) {
        HashSet<File> out = new HashSet<File>();
        for (Map.Entry<Level, Set<File>> mapEntry : fileLogs.entrySet()) {
            if (mapEntry.getKey().getPriority() > level.getPriority()) continue;
            out.addAll((Collection<File>)mapEntry.getValue());
        }
        return out;
    }

    private static void logToFiles(String msg, Level level) {
        Set<File> files = SimpleLog.collectFiles(level);
        for (File file : files) {
            try {
                Files.write(file.toPath(), (msg + '\n').getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(LogListener listener) {
        Set<LogListener> set = listeners;
        synchronized (set) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(LogListener listener) {
        Set<LogListener> set = listeners;
        synchronized (set) {
            listeners.remove(listener);
        }
    }

    private SimpleLog(String name) {
        this.name = name;
    }

    public void setLevel(Level lev) {
        this.level = lev;
    }

    public Level getLevel() {
        return this.level;
    }

    public Level getEffectiveLevel() {
        return this.level == null ? LEVEL : this.level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Level level, Object msg) {
        Set<LogListener> set = listeners;
        synchronized (set) {
            for (LogListener listener : listeners) {
                listener.onLog(this, level, msg);
            }
        }
        String format = ENABLE_GUI && !SimpleLog.isConsolePresent() ? MSGFORMAT : FORMAT;
        format = format.replace("%time%", DFORMAT.format(new Date())).replace("%level%", level.getTag()).replace("%name%", this.name).replace(MSGFORMAT, String.valueOf(msg));
        if (level == Level.OFF || level.getPriority() < (this.level == null ? LEVEL.getPriority() : this.level.getPriority())) {
            SimpleLog.logToFiles(format, level);
        } else {
            this.print(format, level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Throwable ex) {
        Set<LogListener> set = listeners;
        synchronized (set) {
            for (LogListener listener : listeners) {
                listener.onError(this, ex);
            }
        }
        this.log(Level.FATAL, "Encountered an exception:");
        this.log(Level.FATAL, Helpers.getStackTrace(ex));
    }

    public void trace(Object msg) {
        this.log(Level.TRACE, msg);
    }

    public void debug(Object msg) {
        this.log(Level.DEBUG, msg);
    }

    public void info(Object msg) {
        this.log(Level.INFO, msg);
    }

    public void warn(Object msg) {
        this.log(Level.WARNING, msg);
    }

    public void fatal(Object msg) {
        this.log(Level.FATAL, msg);
    }

    private void print(String msg, Level level) {
        if (ENABLE_GUI && !SimpleLog.isConsolePresent()) {
            if (level.isError()) {
                JOptionPane.showMessageDialog(null, msg, "An Error occurred!", 0);
            } else {
                JOptionPane.showMessageDialog(null, msg, level.getTag(), 1);
            }
        } else if (level.isError()) {
            System.err.println(msg);
        } else {
            System.out.println(msg);
        }
    }

    public static boolean isConsolePresent() {
        return System.console() != null;
    }

    public static enum Level {
        ALL("Finest", 0, false),
        TRACE("Trace", 1, false),
        DEBUG("Debug", 2, false),
        INFO("Info", 3, false),
        WARNING("Warning", 4, true),
        FATAL("Fatal", 5, true),
        OFF("NO-LOGGING", 6, true);

        private final String msg;
        private final int pri;
        private final boolean isError;

        private Level(String message, int priority, boolean isError) {
            this.msg = message;
            this.pri = priority;
            this.isError = isError;
        }

        public String getTag() {
            return this.msg;
        }

        public int getPriority() {
            return this.pri;
        }

        public boolean isError() {
            return this.isError;
        }
    }

    public static interface LogListener {
        public void onLog(SimpleLog var1, Level var2, Object var3);

        public void onError(SimpleLog var1, Throwable var2);
    }
}

