/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.dv8tion.jda.core.requests.Requester;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Response
implements Closeable {
    public static final int ERROR_CODE = -1;
    public static final String ERROR_MESSAGE = "ERROR";
    public final int code;
    public final String message;
    public final long retryAfter;
    private final Object object;
    private final okhttp3.Response rawResponse;
    private final Set<String> cfRays;
    private Exception exception;

    protected Response(okhttp3.Response response, Exception exception, Set<String> cfRays) {
        this(response, response != null ? response.code() : -1, ERROR_MESSAGE, -1L, cfRays);
        this.exception = exception;
    }

    protected Response(okhttp3.Response response, int code, String message, long retryAfter, Set<String> cfRays) {
        this.rawResponse = response;
        this.code = code;
        this.message = message;
        this.exception = null;
        this.retryAfter = retryAfter;
        this.cfRays = cfRays;
        if (response == null || response.body().contentLength() == 0L) {
            this.object = null;
            return;
        }
        InputStream body = null;
        BufferedReader reader = null;
        try {
            char begin;
            body = Requester.getBody(response);
            reader = new BufferedReader(new InputStreamReader(body));
            int mark = 1;
            do {
                reader.mark(mark++);
            } while (Character.isWhitespace(begin = (char)reader.read()));
            reader.reset();
            this.object = begin == '{' ? new JSONObject(new JSONTokener(reader)) : (begin == '[' ? new JSONArray(new JSONTokener(reader)) : reader.lines().collect(Collectors.joining()));
        }
        catch (Exception e) {
            throw new IllegalStateException("An error occurred while parsing the response for a RestAction", e);
        }
        finally {
            try {
                body.close();
                reader.close();
            }
            catch (IOException | NullPointerException exception) {}
        }
    }

    protected Response(long retryAfter, Set<String> cfRays) {
        this(null, 429, "TOO MANY REQUESTS", retryAfter, cfRays);
    }

    protected Response(okhttp3.Response response, long retryAfter, Set<String> cfRays) {
        this(response, response.code(), response.message(), retryAfter, cfRays);
    }

    public JSONArray getArray() {
        return this.object instanceof JSONArray ? (JSONArray)this.object : null;
    }

    public JSONObject getObject() {
        return this.object instanceof JSONObject ? (JSONObject)this.object : null;
    }

    public String getString() {
        return Objects.toString(this.object);
    }

    public okhttp3.Response getRawResponse() {
        return this.rawResponse;
    }

    public Set<String> getCFRays() {
        return this.cfRays;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isError() {
        return this.code == -1;
    }

    public boolean isOk() {
        return this.code > 199 && this.code < 300;
    }

    public boolean isRateLimit() {
        return this.code == 429;
    }

    public String toString() {
        return this.exception == null ? "HTTPResponse[" + this.code + (this.object == null ? "" : ", " + this.object.toString()) + ']' : "HTTPException[" + this.exception.getMessage() + ']';
    }

    @Override
    public void close() {
        if (this.rawResponse != null) {
            this.rawResponse.close();
        }
    }
}

