/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.managers.fields;

import java.util.Objects;
import java.util.function.Supplier;

public abstract class Field<T, M> {
    protected final M manager;
    protected final Supplier<T> originalValue;
    protected T value;
    protected boolean set;

    public Field(M manager, Supplier<T> originalValue) {
        this.manager = manager;
        this.originalValue = originalValue;
        this.value = null;
        this.set = false;
    }

    public T getValue() {
        return this.value;
    }

    public T getOriginalValue() {
        return this.originalValue.get();
    }

    public M setValue(T value) {
        this.checkValue(value);
        this.value = value;
        this.set = true;
        return this.manager;
    }

    public boolean isSet() {
        return this.set;
    }

    public boolean shouldUpdate() {
        return this.isSet() && !this.equals(this.getOriginalValue());
    }

    public M getManager() {
        return this.manager;
    }

    public M reset() {
        this.value = null;
        this.set = false;
        return this.manager;
    }

    public abstract void checkValue(T var1);

    public boolean equals(Object o) {
        return this.isSet() && Objects.equals(o, this.value);
    }

    public String toString() {
        throw new UnsupportedOperationException("toString is disabled for Fields due to possible, accidental usage in JSON bodies.");
    }
}

