/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.managers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.GuildVoiceState;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.entities.Icon;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.EmoteImpl;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.MemberImpl;
import net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.dv8tion.jda.core.exceptions.GuildUnavailableException;
import net.dv8tion.jda.core.exceptions.HierarchyException;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.exceptions.PermissionException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.core.requests.restaction.ChannelAction;
import net.dv8tion.jda.core.requests.restaction.RoleAction;
import net.dv8tion.jda.core.requests.restaction.WebhookAction;
import net.dv8tion.jda.core.requests.restaction.order.ChannelOrderAction;
import net.dv8tion.jda.core.requests.restaction.order.RoleOrderAction;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.MiscUtil;
import net.dv8tion.jda.core.utils.PermissionUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class GuildController {
    protected final GuildImpl guild;

    public GuildController(Guild guild) {
        this.guild = (GuildImpl)guild;
    }

    public Guild getGuild() {
        return this.guild;
    }

    public JDA getJDA() {
        return this.guild.getJDA();
    }

    @CheckReturnValue
    public RestAction<Void> moveVoiceMember(Member member, VoiceChannel voiceChannel) {
        this.checkAvailable();
        Checks.notNull(member, "member");
        Checks.notNull(member, "voiceChannel");
        this.checkGuild(member.getGuild(), "member");
        this.checkGuild(voiceChannel.getGuild(), "voiceChannel");
        GuildVoiceState vState = member.getVoiceState();
        if (!vState.inVoiceChannel()) {
            throw new IllegalStateException("You cannot move a Member who isn't in a VoiceChannel!");
        }
        if (!PermissionUtil.checkPermission(vState.getChannel(), this.guild.getSelfMember(), Permission.VOICE_MOVE_OTHERS)) {
            throw new InsufficientPermissionException(Permission.VOICE_MOVE_OTHERS, "This account does not have Permission to MOVE_OTHERS out of the channel that the Member is currently in.");
        }
        if (!PermissionUtil.checkPermission(voiceChannel, this.guild.getSelfMember(), Permission.VOICE_CONNECT) && !PermissionUtil.checkPermission(voiceChannel, member, Permission.VOICE_CONNECT)) {
            throw new InsufficientPermissionException(Permission.VOICE_CONNECT, "Neither this account nor the Member that is attempting to be moved have the VOICE_CONNECT permission for the destination VoiceChannel, so the move cannot be done.");
        }
        JSONObject body = new JSONObject().put("channel_id", voiceChannel.getId());
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.guild.getId(), member.getUser().getId());
        return new RestAction<Void>((JDA)this.guild.getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> setNickname(Member member, String nickname) {
        this.checkAvailable();
        Checks.notNull(member, "member");
        this.checkGuild(member.getGuild(), "member");
        if (member.equals(this.guild.getSelfMember())) {
            if (!member.hasPermission(Permission.NICKNAME_CHANGE) && !member.hasPermission(Permission.NICKNAME_MANAGE)) {
                throw new InsufficientPermissionException(Permission.NICKNAME_CHANGE, "You neither have NICKNAME_CHANGE nor NICKNAME_MANAGE permission!");
            }
        } else {
            this.checkPermission(Permission.NICKNAME_MANAGE);
            this.checkPosition(member);
        }
        if (Objects.equals(nickname, member.getNickname())) {
            return new AuditableRestAction.EmptyRestAction<Object>(this.getJDA(), null);
        }
        if (nickname == null) {
            nickname = "";
        }
        JSONObject body = new JSONObject().put("nick", nickname);
        Route.CompiledRoute route = member.equals(this.guild.getSelfMember()) ? Route.Guilds.MODIFY_SELF_NICK.compile(this.guild.getId()) : Route.Guilds.MODIFY_MEMBER.compile(this.guild.getId(), member.getUser().getId());
        return new AuditableRestAction<Void>((JDA)this.guild.getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Integer> prune(int days) {
        this.checkAvailable();
        this.checkPermission(Permission.KICK_MEMBERS);
        if (days < 1) {
            throw new IllegalArgumentException("Days amount must be at minimum 1 day.");
        }
        Route.CompiledRoute route = Route.Guilds.PRUNE_MEMBERS.compile(this.guild.getId()).withQueryParams("days", Integer.toString(days));
        return new AuditableRestAction<Integer>((JDA)this.guild.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Integer> request) {
                if (response.isOk()) {
                    request.onSuccess(response.getObject().getInt("pruned"));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> kick(Member member, String reason) {
        this.checkAvailable();
        Checks.notNull(member, "member");
        this.checkGuild(member.getGuild(), "member");
        this.checkPermission(Permission.KICK_MEMBERS);
        this.checkPosition(member);
        String userId = member.getUser().getId();
        String guildId = this.guild.getId();
        Route.CompiledRoute route = Route.Guilds.KICK_MEMBER.compile(guildId, userId);
        if (reason != null && !reason.isEmpty()) {
            route = route.withQueryParams("reason", MiscUtil.encodeUTF8(reason));
        }
        return new AuditableRestAction<Void>((JDA)this.guild.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> kick(String userId, String reason) {
        Checks.notBlank(userId, "userId");
        Member member = this.guild.getMemberById(userId);
        if (member == null) {
            throw new IllegalArgumentException("The provided userId does not correspond to a member in this guild! Provided userId: " + userId);
        }
        return this.kick(member, reason);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> kick(Member member) {
        return this.kick(member, null);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> kick(String userId) {
        return this.kick(userId, null);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> ban(Member member, int delDays, String reason) {
        this.checkAvailable();
        Checks.notNull(member, "member");
        return this.ban(member.getUser(), delDays, reason);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> ban(User user, int delDays, String reason) {
        this.checkAvailable();
        Checks.notNull(user, "user");
        this.checkPermission(Permission.BAN_MEMBERS);
        if (this.guild.isMember(user)) {
            this.checkPosition(this.guild.getMember(user));
        }
        if (delDays < 0) {
            throw new IllegalArgumentException("Provided delDays cannot be less that 0. How can you delete messages that are -1 days old?");
        }
        String userId = user.getId();
        Route.CompiledRoute route = Route.Guilds.BAN.compile(this.guild.getId(), userId);
        if (reason != null && !reason.isEmpty()) {
            route = route.withQueryParams("reason", MiscUtil.encodeUTF8(reason));
        }
        if (delDays > 0) {
            route = route.withQueryParams("delete-message-days", Integer.toString(delDays));
        }
        return new AuditableRestAction<Void>((JDA)this.guild.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> ban(final String userId, int delDays, String reason) {
        this.checkAvailable();
        Checks.notBlank(userId, "userId");
        this.checkPermission(Permission.BAN_MEMBERS);
        User user = this.guild.getJDA().getUserById(userId);
        if (user != null) {
            return this.ban(user, delDays, reason);
        }
        Route.CompiledRoute route = Route.Guilds.BAN.compile(this.guild.getId(), userId);
        if (reason != null && !reason.isEmpty()) {
            route = route.withQueryParams("reason", MiscUtil.encodeUTF8(reason));
        }
        if (delDays > 0) {
            route = route.withQueryParams("delete-message-days", Integer.toString(delDays));
        }
        return new AuditableRestAction<Void>((JDA)this.guild.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else if (response.code == 404) {
                    request.onFailure(new IllegalArgumentException("User with provided id \"" + userId + "\" does not exist! Cannot ban a non-existent user!"));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> ban(Member member, int delDays) {
        return this.ban(member, delDays, null);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> ban(User user, int delDays) {
        return this.ban(user, delDays, null);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> ban(String userId, int delDays) {
        return this.ban(userId, delDays, null);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> unban(User user) {
        Checks.notNull(user, "user");
        return this.unban(user.getId());
    }

    @CheckReturnValue
    public AuditableRestAction<Void> unban(final String userId) {
        this.checkAvailable();
        Checks.notBlank(userId, "userId");
        this.checkPermission(Permission.BAN_MEMBERS);
        Route.CompiledRoute route = Route.Guilds.UNBAN.compile(this.guild.getId(), userId);
        return new AuditableRestAction<Void>((JDA)this.guild.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else if (response.code == 404) {
                    request.onFailure(new IllegalArgumentException("User with provided id \"" + userId + "\" does not exist! Cannot unban a non-existent user!"));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> setDeafen(Member member, boolean deafen) {
        this.checkAvailable();
        Checks.notNull(member, "member");
        this.checkGuild(member.getGuild(), "member");
        this.checkPermission(Permission.VOICE_DEAF_OTHERS);
        if (this.guild.getOwner().equals(member)) {
            throw new HierarchyException("Cannot modify Guild Deafen status the Owner of the Guild");
        }
        if (member.getVoiceState().isGuildDeafened() == deafen) {
            return new AuditableRestAction.EmptyRestAction<Object>(this.getJDA(), null);
        }
        JSONObject body = new JSONObject().put("deaf", deafen);
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.guild.getId(), member.getUser().getId());
        return new AuditableRestAction<Void>((JDA)this.guild.getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> setMute(Member member, boolean mute) {
        this.checkAvailable();
        Checks.notNull(member, "member");
        this.checkGuild(member.getGuild(), "member");
        this.checkPermission(Permission.VOICE_MUTE_OTHERS);
        if (this.guild.getOwner().equals(member)) {
            throw new HierarchyException("Cannot modify Guild Mute status the Owner of the Guild");
        }
        if (member.getVoiceState().isGuildMuted() == mute) {
            return new AuditableRestAction.EmptyRestAction<Object>(this.getJDA(), null);
        }
        JSONObject body = new JSONObject().put("mute", mute);
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.guild.getId(), member.getUser().getId());
        return new AuditableRestAction<Void>((JDA)this.guild.getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> addSingleRoleToMember(Member member, Role role) {
        Checks.notNull(member, "Member");
        Checks.notNull(role, "Role");
        this.checkGuild(member.getGuild(), "Member is not from the same Guild!");
        this.checkGuild(role.getGuild(), "Role is not from the same Guild!");
        this.checkPermission(Permission.MANAGE_ROLES);
        this.checkPosition(role);
        Route.CompiledRoute route = Route.Guilds.ADD_MEMBER_ROLE.compile(this.guild.getId(), member.getUser().getId(), role.getId());
        return new AuditableRestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> removeSingleRoleFromMember(Member member, Role role) {
        Checks.notNull(member, "Member");
        Checks.notNull(role, "Role");
        this.checkGuild(member.getGuild(), "Member is not from the same Guild!");
        this.checkGuild(role.getGuild(), "Role is not from the same Guild!");
        this.checkPermission(Permission.MANAGE_ROLES);
        this.checkPosition(role);
        Route.CompiledRoute route = Route.Guilds.REMOVE_MEMBER_ROLE.compile(this.guild.getId(), member.getUser().getId(), role.getId());
        return new AuditableRestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> addRolesToMember(Member member, Role ... roles) {
        return this.modifyMemberRoles(member, Arrays.asList(roles), Collections.emptyList());
    }

    @CheckReturnValue
    public AuditableRestAction<Void> addRolesToMember(Member member, Collection<Role> roles) {
        return this.modifyMemberRoles(member, roles, Collections.emptyList());
    }

    @CheckReturnValue
    public AuditableRestAction<Void> removeRolesFromMember(Member member, Role ... roles) {
        return this.modifyMemberRoles(member, Collections.emptyList(), Arrays.asList(roles));
    }

    @CheckReturnValue
    public AuditableRestAction<Void> removeRolesFromMember(Member member, Collection<Role> roles) {
        return this.modifyMemberRoles(member, Collections.emptyList(), roles);
    }

    @CheckReturnValue
    public AuditableRestAction<Void> modifyMemberRoles(Member member, Collection<Role> rolesToAdd, Collection<Role> rolesToRemove) {
        this.checkAvailable();
        Checks.notNull(member, "member");
        Checks.notNull(rolesToAdd, "Collection containing roles to be added to the member");
        Checks.notNull(rolesToRemove, "Collection containing roles to be removed from the member");
        this.checkGuild(member.getGuild(), "member");
        this.checkPermission(Permission.MANAGE_ROLES);
        rolesToAdd.forEach(role -> {
            Checks.notNull(role, "role in rolesToAdd");
            this.checkGuild(role.getGuild(), "role: " + role.toString());
            this.checkPosition((Role)role);
            if (role.isManaged()) {
                throw new IllegalArgumentException("Cannot add a Managed role to a Member. Role: " + role.toString());
            }
        });
        rolesToRemove.forEach(role -> {
            Checks.notNull(role, "role in rolesToRemove");
            this.checkGuild(role.getGuild(), "role: " + role.toString());
            this.checkPosition((Role)role);
            if (role.isManaged()) {
                throw new IllegalArgumentException("Cannot remove a Managed role from a Member. Role: " + role.toString());
            }
        });
        HashSet<Role> currentRoles = new HashSet<Role>(((MemberImpl)member).getRoleSet());
        currentRoles.addAll(rolesToAdd);
        currentRoles.removeAll(rolesToRemove);
        if (currentRoles.contains(this.guild.getPublicRole())) {
            throw new IllegalArgumentException("Cannot add the PublicRole of a Guild to a Member. All members have this role by default!");
        }
        JSONObject body = new JSONObject().put("roles", currentRoles.stream().map(ISnowflake::getId).collect(Collectors.toList()));
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.guild.getId(), member.getUser().getId());
        return new AuditableRestAction<Void>((JDA)this.guild.getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> modifyMemberRoles(Member member, Role ... roles) {
        return this.modifyMemberRoles(member, Arrays.asList(roles));
    }

    @CheckReturnValue
    public AuditableRestAction<Void> modifyMemberRoles(Member member, Collection<Role> roles) {
        block7: {
            List newManaged;
            List currentManaged;
            block6: {
                this.checkAvailable();
                Checks.notNull(member, "member");
                Checks.notNull(roles, "roles");
                this.checkGuild(member.getGuild(), "member");
                roles.forEach(role -> {
                    Checks.notNull(role, "role in collection");
                    this.checkGuild(role.getGuild(), "role: " + role.toString());
                    this.checkPosition((Role)role);
                });
                if (roles.contains(this.guild.getPublicRole())) {
                    throw new IllegalArgumentException("Cannot add the PublicRole of a Guild to a Member. All members have this role by default!");
                }
                currentManaged = roles.stream().filter(Role::isManaged).collect(Collectors.toList());
                newManaged = roles.stream().filter(Role::isManaged).collect(Collectors.toList());
                if (currentManaged.size() != 0) break block6;
                if (newManaged.size() == 0) break block7;
            }
            currentManaged.removeIf(newManaged::contains);
            if (currentManaged.size() > 0) {
                throw new IllegalArgumentException("Cannot remove managed roles from a member! Roles: " + currentManaged.toString());
            }
            if (newManaged.size() > 0) {
                throw new IllegalArgumentException("Cannot add managed roles to a member! Roles: " + newManaged.toString());
            }
        }
        JSONObject body = new JSONObject().put("roles", roles.stream().map(ISnowflake::getId).collect(Collectors.toList()));
        Route.CompiledRoute route = Route.Guilds.MODIFY_MEMBER.compile(this.guild.getId(), member.getUser().getId());
        return new AuditableRestAction<Void>((JDA)this.guild.getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public AuditableRestAction<Void> transferOwnership(Member newOwner) {
        this.checkAvailable();
        Checks.notNull(newOwner, "newOwner member");
        this.checkGuild(newOwner.getGuild(), "newOwner member");
        if (!this.guild.getOwner().equals(this.guild.getSelfMember())) {
            throw new PermissionException("The logged in account must be the owner of this Guild to be able to transfer ownership");
        }
        if (this.guild.getSelfMember().equals(newOwner)) {
            throw new IllegalArgumentException("The member provided as the newOwner is the currently logged in account. Provide a different member to give ownership to.");
        }
        if (newOwner.getUser().isBot()) {
            throw new IllegalArgumentException("Cannot transfer ownership of a Guild to a Bot!");
        }
        JSONObject body = new JSONObject().put("owner_id", newOwner.getUser().getId());
        Route.CompiledRoute route = Route.Guilds.MODIFY_GUILD.compile(this.guild.getId());
        return new AuditableRestAction<Void>((JDA)this.guild.getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public ChannelAction createTextChannel(String name) {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_CHANNEL);
        Checks.notBlank(name, "name");
        if (name.length() < 2 || name.length() > 100) {
            throw new IllegalArgumentException("Provided name must be 2 - 100 characters in length");
        }
        Route.CompiledRoute route = Route.Guilds.CREATE_CHANNEL.compile(this.guild.getId());
        return new ChannelAction(route, name, this.guild, ChannelType.TEXT);
    }

    @CheckReturnValue
    public ChannelAction createVoiceChannel(String name) {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_CHANNEL);
        Checks.notBlank(name, "name");
        if (name.length() < 2 || name.length() > 100) {
            throw new IllegalArgumentException("Provided name must be 2 to 100 characters in length");
        }
        Route.CompiledRoute route = Route.Guilds.CREATE_CHANNEL.compile(this.guild.getId());
        return new ChannelAction(route, name, this.guild, ChannelType.VOICE);
    }

    @CheckReturnValue
    public ChannelAction createCategory(String name) {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_CHANNEL);
        Checks.notBlank(name, "name");
        if (name.length() < 2 || name.length() > 100) {
            throw new IllegalArgumentException("Provided name must be 2 to 100 characters in length");
        }
        Route.CompiledRoute route = Route.Guilds.CREATE_CHANNEL.compile(this.guild.getId());
        return new ChannelAction(route, name, this.guild, ChannelType.CATEGORY);
    }

    @CheckReturnValue
    public ChannelAction createCopyOfChannel(Channel channel) {
        Checks.notNull(channel, "Channel");
        this.checkPermission(Permission.MANAGE_CHANNEL);
        Route.CompiledRoute route = Route.Guilds.CREATE_CHANNEL.compile(this.guild.getId());
        ChannelAction action = new ChannelAction(route, channel.getName(), this.guild, channel.getType());
        switch (channel.getType()) {
            case VOICE: {
                VoiceChannel voice = (VoiceChannel)channel;
                action.setBitrate(voice.getBitrate()).setUserlimit(voice.getUserLimit());
                break;
            }
            case TEXT: {
                TextChannel text = (TextChannel)channel;
                action.setTopic(text.getTopic()).setNSFW(text.isNSFW());
            }
        }
        return action;
    }

    @CheckReturnValue
    public WebhookAction createWebhook(TextChannel channel, String name) {
        Checks.notNull(name, "Webhook name");
        Checks.notNull(channel, "TextChannel");
        this.checkGuild(channel.getGuild(), "channel");
        if (!this.guild.getSelfMember().hasPermission((Channel)channel, Permission.MANAGE_WEBHOOKS)) {
            throw new InsufficientPermissionException(Permission.MANAGE_WEBHOOKS);
        }
        Route.CompiledRoute route = Route.Channels.CREATE_WEBHOOK.compile(channel.getId());
        return new WebhookAction(this.getJDA(), route, name);
    }

    @CheckReturnValue
    public RoleAction createRole() {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_ROLES);
        Route.CompiledRoute route = Route.Roles.CREATE_ROLE.compile(this.guild.getId());
        return new RoleAction(route, this.guild);
    }

    @CheckReturnValue
    public RoleAction createCopyOfRole(Role role) {
        return this.createRole().setColor(role.getColor()).setPermissions(role.getPermissionsRaw()).setName(role.getName()).setHoisted(role.isHoisted()).setMentionable(role.isMentionable());
    }

    @CheckReturnValue
    public AuditableRestAction<Emote> createEmote(String name, Icon icon, Role ... roles) {
        this.checkAvailable();
        this.checkPermission(Permission.MANAGE_EMOTES);
        Checks.notNull(name, "emote name");
        Checks.notNull(icon, "emote icon");
        if (this.getJDA().getAccountType() != AccountType.CLIENT) {
            throw new AccountTypeException(AccountType.CLIENT);
        }
        JSONObject body = new JSONObject();
        body.put("name", name);
        body.put("image", icon.getEncoding());
        if (roles.length > 0) {
            body.put("roles", Stream.of(roles).filter(Objects::nonNull).map(ISnowflake::getId).collect(Collectors.toSet()));
        }
        Route.CompiledRoute route = Route.Emotes.CREATE_EMOTE.compile(this.guild.getId());
        return new AuditableRestAction<Emote>(this.getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Emote> request) {
                if (response.isOk()) {
                    JSONObject obj = response.getObject();
                    long id = obj.getLong("id");
                    String name = obj.getString("name");
                    EmoteImpl emote = new EmoteImpl(id, GuildController.this.guild).setName(name);
                    JSONArray rolesArr = obj.getJSONArray("roles");
                    HashSet<Role> roleSet = emote.getRoleSet();
                    for (int i = 0; i < rolesArr.length(); ++i) {
                        roleSet.add(GuildController.this.guild.getRoleById(rolesArr.getString(i)));
                    }
                    GuildController.this.guild.getEmoteMap().put(id, emote);
                    request.onSuccess(emote);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    public ChannelOrderAction<Category> modifyCategoryPositions() {
        return new ChannelOrderAction<Category>(this.guild, ChannelType.CATEGORY);
    }

    @CheckReturnValue
    public ChannelOrderAction<TextChannel> modifyTextChannelPositions() {
        return new ChannelOrderAction<TextChannel>(this.guild, ChannelType.TEXT);
    }

    @CheckReturnValue
    public ChannelOrderAction<VoiceChannel> modifyVoiceChannelPositions() {
        return new ChannelOrderAction<VoiceChannel>(this.guild, ChannelType.VOICE);
    }

    @CheckReturnValue
    public RoleOrderAction modifyRolePositions() {
        return this.modifyRolePositions(true);
    }

    @CheckReturnValue
    public RoleOrderAction modifyRolePositions(boolean useDiscordOrder) {
        return new RoleOrderAction(this.guild, useDiscordOrder);
    }

    protected void checkAvailable() {
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
    }

    protected void checkGuild(Guild providedGuild, String comment) {
        if (!this.guild.equals(providedGuild)) {
            throw new IllegalArgumentException("Provided " + comment + " is not part of this Guild!");
        }
    }

    protected void checkPermission(Permission perm) {
        if (!this.guild.getSelfMember().hasPermission(perm)) {
            throw new InsufficientPermissionException(perm);
        }
    }

    protected void checkPosition(Member member) {
        if (!this.guild.getSelfMember().canInteract(member)) {
            throw new HierarchyException("Can't modify a member with higher or equal highest role than yourself!");
        }
    }

    protected void checkPosition(Role role) {
        if (!this.guild.getSelfMember().canInteract(role)) {
            throw new HierarchyException("Can't modify a role with higher or equal highest role than yourself! Role: " + role.toString());
        }
    }
}

