/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.MemberImpl;
import net.dv8tion.jda.core.events.guild.member.GuildMemberNickChangeEvent;
import net.dv8tion.jda.core.events.guild.member.GuildMemberRoleAddEvent;
import net.dv8tion.jda.core.events.guild.member.GuildMemberRoleRemoveEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import org.json.JSONArray;
import org.json.JSONObject;

public class GuildMemberUpdateHandler
extends SocketHandler {
    public GuildMemberUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long id = content.getLong("guild_id");
        if (this.api.getGuildLock().isLocked(id)) {
            return id;
        }
        JSONObject userJson = content.getJSONObject("user");
        long userId = userJson.getLong("id");
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(id);
        if (guild == null) {
            this.api.getEventCache().cache(EventCache.Type.GUILD, userId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Got GuildMember update but JDA currently does not have the Guild cached. " + content.toString());
            return null;
        }
        MemberImpl member = (MemberImpl)guild.getMembersMap().get(userId);
        if (member == null) {
            this.api.getEventCache().cache(EventCache.Type.USER, userId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Got GuildMember update but Member is not currently present in Guild. " + content.toString());
            return null;
        }
        Set<Role> currentRoles = member.getRoleSet();
        List<Role> newRoles = this.toRolesList(guild, content.getJSONArray("roles"));
        if (newRoles == null) {
            return null;
        }
        LinkedList<Role> removedRoles = new LinkedList<Role>();
        block0: for (Role role : currentRoles) {
            Iterator<Role> it = newRoles.iterator();
            while (it.hasNext()) {
                Role r = it.next();
                if (!role.equals(r)) continue;
                it.remove();
                continue block0;
            }
            removedRoles.add(role);
        }
        if (removedRoles.size() > 0) {
            currentRoles.removeAll(removedRoles);
        }
        if (newRoles.size() > 0) {
            currentRoles.addAll(newRoles);
        }
        if (removedRoles.size() > 0) {
            this.api.getEventManager().handle(new GuildMemberRoleRemoveEvent(this.api, this.responseNumber, guild, member, removedRoles));
        }
        if (newRoles.size() > 0) {
            this.api.getEventManager().handle(new GuildMemberRoleAddEvent(this.api, this.responseNumber, guild, member, newRoles));
        }
        if (content.has("nick")) {
            String newNick;
            String prevNick = member.getNickname();
            String string = newNick = content.isNull("nick") ? null : content.getString("nick");
            if (!Objects.equals(prevNick, newNick)) {
                member.setNickname(newNick);
                this.api.getEventManager().handle(new GuildMemberNickChangeEvent(this.api, this.responseNumber, guild, member, prevNick, newNick));
            }
        }
        return null;
    }

    private List<Role> toRolesList(GuildImpl guild, JSONArray array) {
        LinkedList<Role> roles = new LinkedList<Role>();
        for (int i = 0; i < array.length(); ++i) {
            long id = array.getLong(i);
            Role r = guild.getRolesMap().get(id);
            if (r == null) {
                this.api.getEventCache().cache(EventCache.Type.ROLE, id, () -> this.handle(this.responseNumber, this.allContent));
                EventCache.LOG.debug("Got GuildMember update but one of the Roles for the Member is not yet cached.");
                return null;
            }
            roles.add(r);
        }
        return roles;
    }
}

