/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.exceptions;

import net.dv8tion.jda.core.requests.ErrorResponse;
import net.dv8tion.jda.core.requests.Response;
import org.json.JSONObject;

public class ErrorResponseException
extends RuntimeException {
    private final ErrorResponse errorResponse;
    private final Response response;
    private final String meaning;
    private final int code;

    private ErrorResponseException(ErrorResponse errorResponse, Response response, int code, String meaning) {
        super(code + ": " + meaning);
        this.response = response;
        this.errorResponse = errorResponse;
        this.code = code;
        this.meaning = meaning;
    }

    public boolean isServerError() {
        return this.errorResponse == ErrorResponse.SERVER_ERROR;
    }

    public String getMeaning() {
        return this.meaning;
    }

    public int getErrorCode() {
        return this.code;
    }

    public ErrorResponse getErrorResponse() {
        return this.errorResponse;
    }

    public Response getResponse() {
        return this.response;
    }

    public static ErrorResponseException create(ErrorResponse errorResponse, Response response) {
        JSONObject obj = response.getObject();
        String meaning = errorResponse.getMeaning();
        int code = errorResponse.getCode();
        if (response.isError() && response.getException() != null) {
            code = response.code;
            meaning = response.getException().getClass().getName();
        } else if (obj != null) {
            if (!obj.isNull("code") || !obj.isNull("message")) {
                if (!obj.isNull("code")) {
                    code = obj.getInt("code");
                }
                if (!obj.isNull("message")) {
                    meaning = obj.getString("message");
                }
            } else {
                code = response.code;
                meaning = response.getString();
            }
        } else {
            code = response.code;
            meaning = response.getString();
        }
        return new ErrorResponseException(errorResponse, response, code, meaning);
    }
}

