/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.utils.MiscUtil;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.json.JSONArray;

public class MessageHistory {
    protected final MessageChannel channel;
    protected final ListOrderedMap<Long, Message> history = new ListOrderedMap();

    public MessageHistory(MessageChannel channel) {
        this.channel = channel;
        if (channel instanceof TextChannel && !((TextChannel)channel).getGuild().getSelfMember().hasPermission(Permission.MESSAGE_HISTORY)) {
            throw new InsufficientPermissionException(Permission.MESSAGE_HISTORY);
        }
    }

    public JDA getJDA() {
        return this.channel.getJDA();
    }

    public int size() {
        return this.history.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    @CheckReturnValue
    public RestAction<List<Message>> retrievePast(int amount) {
        if (amount > 100 || amount < 1) {
            throw new IllegalArgumentException("Message retrieval limit is between 1 and 100 messages. No more, no less. Limit provided: " + amount);
        }
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE_HISTORY.compile(this.channel.getId()).withQueryParams("limit", Integer.toString(amount));
        if (!this.history.isEmpty()) {
            route = route.withQueryParams("before", String.valueOf(this.history.lastKey()));
        }
        return new RestAction<List<Message>>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<List<Message>> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                EntityBuilder builder = this.api.getEntityBuilder();
                LinkedList<Message> msgs = new LinkedList<Message>();
                JSONArray historyJson = response.getArray();
                for (int i = 0; i < historyJson.length(); ++i) {
                    msgs.add(builder.createMessage(historyJson.getJSONObject(i)));
                }
                msgs.forEach(msg -> MessageHistory.this.history.put(msg.getIdLong(), (Message)msg));
                request.onSuccess(msgs);
            }
        };
    }

    @CheckReturnValue
    public RestAction<List<Message>> retrieveFuture(int amount) {
        if (amount > 100 || amount < 1) {
            throw new IllegalArgumentException("Message retrieval limit is between 1 and 100 messages. No more, no less. Limit provided: " + amount);
        }
        if (this.history.isEmpty()) {
            throw new IllegalStateException("No messages have been retrieved yet, so there is no message to act as a marker to retrieve more recent messages based on.");
        }
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE_HISTORY.compile(this.channel.getId()).withQueryParams("limit", Integer.toString(amount), "after", String.valueOf(this.history.firstKey()));
        return new RestAction<List<Message>>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<List<Message>> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                EntityBuilder builder = this.api.getEntityBuilder();
                LinkedList<Message> msgs = new LinkedList<Message>();
                JSONArray historyJson = response.getArray();
                for (int i = 0; i < historyJson.length(); ++i) {
                    msgs.add(builder.createMessage(historyJson.getJSONObject(i)));
                }
                Iterator it = msgs.descendingIterator();
                while (it.hasNext()) {
                    Message m = (Message)it.next();
                    MessageHistory.this.history.put(0, m.getIdLong(), m);
                }
                request.onSuccess(msgs);
            }
        };
    }

    public List<Message> getRetrievedHistory() {
        int size = this.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            return Collections.singletonList(this.history.getValue(0));
        }
        return Collections.unmodifiableList(new ArrayList<Message>(this.history.values()));
    }

    public Message getMessageById(String id) {
        return this.getMessageById(MiscUtil.parseSnowflake(id));
    }

    public Message getMessageById(long id) {
        return (Message)this.history.get(id);
    }
}

