/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.dv8tion.jda.core.utils.Checks;

public enum Permission {
    CREATE_INSTANT_INVITE(0, true, true, "Create Instant Invite"),
    KICK_MEMBERS(1, true, false, "Kick Members"),
    BAN_MEMBERS(2, true, false, "Ban Members"),
    ADMINISTRATOR(3, true, false, "Administrator"),
    MANAGE_CHANNEL(4, true, true, "Manage Channels"),
    MANAGE_SERVER(5, true, false, "Manage Server"),
    MESSAGE_ADD_REACTION(6, true, true, "Add Reactions"),
    VIEW_AUDIT_LOGS(7, true, false, "View Audit Logs"),
    MESSAGE_READ(10, true, true, "Read Messages"),
    MESSAGE_WRITE(11, true, true, "Send Messages"),
    MESSAGE_TTS(12, true, true, "Send TTS Messages"),
    MESSAGE_MANAGE(13, true, true, "Manage Messages"),
    MESSAGE_EMBED_LINKS(14, true, true, "Embed Links"),
    MESSAGE_ATTACH_FILES(15, true, true, "Attach Files"),
    MESSAGE_HISTORY(16, true, true, "Read History"),
    MESSAGE_MENTION_EVERYONE(17, true, true, "Mention Everyone"),
    MESSAGE_EXT_EMOJI(18, true, true, "Use External Emojis"),
    VOICE_CONNECT(20, true, true, "Connect"),
    VOICE_SPEAK(21, true, true, "Speak"),
    VOICE_MUTE_OTHERS(22, true, true, "Mute Members"),
    VOICE_DEAF_OTHERS(23, true, true, "Deafen Members"),
    VOICE_MOVE_OTHERS(24, true, true, "Move Members"),
    VOICE_USE_VAD(25, true, true, "Use Voice Activity"),
    NICKNAME_CHANGE(26, true, false, "Change Nickname"),
    NICKNAME_MANAGE(27, true, false, "Manage Nicknames"),
    MANAGE_ROLES(28, true, false, "Manage Roles"),
    MANAGE_PERMISSIONS(28, false, true, "Manage Permissions"),
    MANAGE_WEBHOOKS(29, true, true, "Manage Webhooks"),
    MANAGE_EMOTES(30, true, false, "Manage Emojis"),
    UNKNOWN(-1, false, false, "Unknown");

    public static final long ALL_PERMISSIONS;
    public static final long ALL_CHANNEL_PERMISSIONS;
    public static final long ALL_GUILD_PERMISSIONS;
    public static final long ALL_TEXT_PERMISSIONS;
    public static final long ALL_VOICE_PERMISSIONS;
    private final int offset;
    private final long raw;
    private final boolean isGuild;
    private final boolean isChannel;
    private final String name;

    private Permission(int offset, boolean isGuild, boolean isChannel, String name) {
        this.offset = offset;
        this.raw = 1 << offset;
        this.isGuild = isGuild;
        this.isChannel = isChannel;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getOffset() {
        return this.offset;
    }

    public long getRawValue() {
        return this.raw;
    }

    public boolean isGuild() {
        return this.isGuild;
    }

    public boolean isChannel() {
        return this.isChannel;
    }

    public boolean isText() {
        return this.offset > 9 && this.offset < 20;
    }

    public boolean isVoice() {
        return this.offset > 19 && this.offset < 26;
    }

    public static Permission getFromOffset(int offset) {
        for (Permission perm : Permission.values()) {
            if (perm.offset != offset) continue;
            return perm;
        }
        return UNKNOWN;
    }

    public static List<Permission> getPermissions(long permissions) {
        LinkedList<Permission> perms = new LinkedList<Permission>();
        for (Permission perm : Permission.values()) {
            if (perm.equals((Object)UNKNOWN) || (permissions >> perm.getOffset() & 1L) != 1L) continue;
            perms.add(perm);
        }
        return perms;
    }

    public static long getRaw(Permission ... permissions) {
        long raw = 0L;
        for (Permission perm : permissions) {
            if (perm == UNKNOWN) continue;
            raw |= perm.raw;
        }
        return raw;
    }

    public static long getRaw(Collection<Permission> permissions) {
        Checks.notNull(permissions, "Permission Collection");
        return Permission.getRaw(permissions.toArray(new Permission[permissions.size()]));
    }

    static {
        ALL_PERMISSIONS = Permission.getRaw(Permission.values());
        ALL_CHANNEL_PERMISSIONS = Permission.getRaw(Arrays.stream(Permission.values()).filter(Permission::isChannel).collect(Collectors.toList()));
        ALL_GUILD_PERMISSIONS = Permission.getRaw(Arrays.stream(Permission.values()).filter(Permission::isGuild).collect(Collectors.toList()));
        ALL_TEXT_PERMISSIONS = Permission.getRaw(Arrays.stream(Permission.values()).filter(Permission::isText).collect(Collectors.toList()));
        ALL_VOICE_PERMISSIONS = Permission.getRaw(Arrays.stream(Permission.values()).filter(Permission::isVoice).collect(Collectors.toList()));
    }
}

