/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core;

import com.neovisionaries.ws.client.WebSocketFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.OnlineStatus;
import net.dv8tion.jda.core.audio.factory.IAudioSendFactory;
import net.dv8tion.jda.core.entities.Game;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.dv8tion.jda.core.exceptions.RateLimitedException;
import net.dv8tion.jda.core.hooks.IEventManager;
import net.dv8tion.jda.core.managers.impl.PresenceImpl;
import net.dv8tion.jda.core.requests.SessionReconnectQueue;
import net.dv8tion.jda.core.utils.Checks;
import okhttp3.OkHttpClient;

public class JDABuilder {
    protected final List<Object> listeners;
    protected SessionReconnectQueue reconnectQueue = null;
    protected OkHttpClient.Builder httpClientBuilder = null;
    protected WebSocketFactory wsFactory = null;
    protected AccountType accountType;
    protected String token = null;
    protected IEventManager eventManager = null;
    protected IAudioSendFactory audioSendFactory = null;
    protected JDA.ShardInfo shardInfo = null;
    protected Game game = null;
    protected OnlineStatus status = OnlineStatus.ONLINE;
    protected int maxReconnectDelay = 900;
    protected int corePoolSize = 2;
    protected boolean enableVoice = true;
    protected boolean enableShutdownHook = true;
    protected boolean enableBulkDeleteSplitting = true;
    protected boolean autoReconnect = true;
    protected boolean idle = false;

    public JDABuilder(AccountType accountType) {
        if (accountType == null) {
            throw new NullPointerException("Provided AccountType was null!");
        }
        this.accountType = accountType;
        this.listeners = new LinkedList<Object>();
    }

    public JDABuilder setReconnectQueue(SessionReconnectQueue queue) {
        this.reconnectQueue = queue;
        return this;
    }

    public JDABuilder setToken(String token) {
        this.token = token;
        return this;
    }

    public JDABuilder setHttpClientBuilder(OkHttpClient.Builder builder) {
        this.httpClientBuilder = builder;
        return this;
    }

    public JDABuilder setWebsocketFactory(WebSocketFactory factory) {
        this.wsFactory = factory;
        return this;
    }

    public JDABuilder setCorePoolSize(int size) {
        Checks.positive(size, "Core pool size");
        this.corePoolSize = size;
        return this;
    }

    public JDABuilder setAudioEnabled(boolean enabled) {
        this.enableVoice = enabled;
        return this;
    }

    public JDABuilder setBulkDeleteSplittingEnabled(boolean enabled) {
        this.enableBulkDeleteSplitting = enabled;
        return this;
    }

    public JDABuilder setEnableShutdownHook(boolean enable) {
        this.enableShutdownHook = enable;
        return this;
    }

    public JDABuilder setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        return this;
    }

    public JDABuilder setEventManager(IEventManager manager) {
        this.eventManager = manager;
        return this;
    }

    public JDABuilder setAudioSendFactory(IAudioSendFactory factory) {
        this.audioSendFactory = factory;
        return this;
    }

    public JDABuilder setIdle(boolean idle) {
        this.idle = idle;
        return this;
    }

    public JDABuilder setGame(Game game) {
        this.game = game;
        return this;
    }

    public JDABuilder setStatus(OnlineStatus status) {
        if (status == null || status == OnlineStatus.UNKNOWN) {
            throw new IllegalArgumentException("OnlineStatus cannot be null or unknown!");
        }
        this.status = status;
        return this;
    }

    public JDABuilder addEventListener(Object ... listeners) {
        Collections.addAll(this.listeners, listeners);
        return this;
    }

    public JDABuilder removeEventListener(Object ... listeners) {
        this.listeners.removeAll(Arrays.asList(listeners));
        return this;
    }

    public JDABuilder setMaxReconnectDelay(int maxReconnectDelay) {
        Checks.check(maxReconnectDelay >= 32, "Max reconnect delay must be 32 seconds or greater. You provided %d.", (Object)maxReconnectDelay);
        this.maxReconnectDelay = maxReconnectDelay;
        return this;
    }

    public JDABuilder useSharding(int shardId, int shardTotal) {
        if (this.accountType != AccountType.BOT) {
            throw new AccountTypeException(AccountType.BOT);
        }
        Checks.notNegative(shardId, "Shard ID");
        Checks.positive(shardTotal, "Shard Total");
        Checks.check(shardId < shardTotal, "The shard ID must be lower than the shardTotal! Shard IDs are 0-based.");
        this.shardInfo = new JDA.ShardInfo(shardId, shardTotal);
        return this;
    }

    public JDA buildAsync() throws LoginException, IllegalArgumentException, RateLimitedException {
        OkHttpClient.Builder httpClientBuilder = this.httpClientBuilder == null ? new OkHttpClient.Builder() : this.httpClientBuilder;
        WebSocketFactory wsFactory = this.wsFactory == null ? new WebSocketFactory() : this.wsFactory;
        JDAImpl jda = new JDAImpl(this.accountType, httpClientBuilder, wsFactory, this.autoReconnect, this.enableVoice, this.enableShutdownHook, this.enableBulkDeleteSplitting, this.corePoolSize, this.maxReconnectDelay);
        if (this.eventManager != null) {
            jda.setEventManager(this.eventManager);
        }
        if (this.audioSendFactory != null) {
            jda.setAudioSendFactory(this.audioSendFactory);
        }
        this.listeners.forEach(xva$0 -> jda.addEventListener(xva$0));
        jda.setStatus(JDA.Status.INITIALIZED);
        ((PresenceImpl)jda.getPresence()).setCacheGame(this.game).setCacheIdle(this.idle).setCacheStatus(this.status);
        jda.login(this.token, this.shardInfo, this.reconnectQueue);
        return jda;
    }

    public JDA buildBlocking() throws LoginException, IllegalArgumentException, InterruptedException, RateLimitedException {
        JDA jda = this.buildAsync();
        while (jda.getStatus() != JDA.Status.CONNECTED) {
            Thread.sleep(50L);
        }
        return jda;
    }
}

