/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core;

import java.util.Collection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.bot.JDABot;
import net.dv8tion.jda.client.JDAClient;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.SelfUser;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.hooks.IEventManager;
import net.dv8tion.jda.core.managers.Presence;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.restaction.AuditableRestAction;

public interface JDA {
    public Status getStatus();

    public long getPing();

    public List<String> getCloudflareRays();

    public List<String> getWebSocketTrace();

    public void setEventManager(IEventManager var1);

    public void addEventListener(Object ... var1);

    public void removeEventListener(Object ... var1);

    public List<Object> getRegisteredListeners();

    public List<User> getUsers();

    public User getUserById(String var1);

    public User getUserById(long var1);

    public List<Guild> getMutualGuilds(User ... var1);

    public List<Guild> getMutualGuilds(Collection<User> var1);

    public List<User> getUsersByName(String var1, boolean var2);

    @CheckReturnValue
    public RestAction<User> retrieveUserById(String var1);

    @CheckReturnValue
    public RestAction<User> retrieveUserById(long var1);

    public List<Guild> getGuilds();

    public Guild getGuildById(String var1);

    public Guild getGuildById(long var1);

    public List<Guild> getGuildsByName(String var1, boolean var2);

    public List<Role> getRoles();

    public Role getRoleById(String var1);

    public Role getRoleById(long var1);

    public List<Role> getRolesByName(String var1, boolean var2);

    public Category getCategoryById(String var1);

    public Category getCategoryById(long var1);

    public List<Category> getCategories();

    public List<Category> getCategoriesByName(String var1, boolean var2);

    public List<TextChannel> getTextChannels();

    public TextChannel getTextChannelById(String var1);

    public TextChannel getTextChannelById(long var1);

    public List<TextChannel> getTextChannelsByName(String var1, boolean var2);

    public List<VoiceChannel> getVoiceChannels();

    public VoiceChannel getVoiceChannelById(String var1);

    public VoiceChannel getVoiceChannelById(long var1);

    public List<VoiceChannel> getVoiceChannelByName(String var1, boolean var2);

    public List<PrivateChannel> getPrivateChannels();

    public PrivateChannel getPrivateChannelById(String var1);

    public PrivateChannel getPrivateChannelById(long var1);

    public List<Emote> getEmotes();

    public Emote getEmoteById(String var1);

    public Emote getEmoteById(long var1);

    public List<Emote> getEmotesByName(String var1, boolean var2);

    public SelfUser getSelfUser();

    public Presence getPresence();

    public ShardInfo getShardInfo();

    public String getToken();

    public long getResponseTotal();

    public int getMaxReconnectDelay();

    public void setAutoReconnect(boolean var1);

    public boolean isAutoReconnect();

    public boolean isAudioEnabled();

    public boolean isBulkDeleteSplittingEnabled();

    public void shutdown();

    public void shutdownNow();

    public AuditableRestAction<Void> installAuxiliaryCable(int var1);

    public AccountType getAccountType();

    public JDAClient asClient();

    public JDABot asBot();

    public static class ShardInfo {
        int shardId;
        int shardTotal;

        ShardInfo(int shardId, int shardTotal) {
            this.shardId = shardId;
            this.shardTotal = shardTotal;
        }

        public int getShardId() {
            return this.shardId;
        }

        public int getShardTotal() {
            return this.shardTotal;
        }

        public String getShardString() {
            return "[" + this.shardId + " / " + this.shardTotal + "]";
        }

        public String toString() {
            return "Shard " + this.getShardString();
        }

        public boolean equals(Object o) {
            if (!(o instanceof ShardInfo)) {
                return false;
            }
            ShardInfo oInfo = (ShardInfo)o;
            return this.shardId == oInfo.shardId && this.shardTotal == oInfo.shardTotal;
        }
    }

    public static enum Status {
        INITIALIZING,
        INITIALIZED,
        LOGGING_IN,
        CONNECTING_TO_WEBSOCKET,
        LOADING_SUBSYSTEMS,
        CONNECTED,
        DISCONNECTED,
        RECONNECT_QUEUED,
        WAITING_TO_RECONNECT,
        ATTEMPTING_TO_RECONNECT,
        SHUTTING_DOWN,
        SHUTDOWN,
        FAILED_TO_LOGIN;

    }
}

