/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.org.apache.http.impl.conn;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import me.iblitzkriegi.vixio.org.apache.http.annotation.ThreadSafe;
import me.iblitzkriegi.vixio.org.apache.http.conn.ManagedHttpClientConnection;
import me.iblitzkriegi.vixio.org.apache.http.conn.routing.HttpRoute;
import me.iblitzkriegi.vixio.org.apache.http.impl.conn.CPoolEntry;
import me.iblitzkriegi.vixio.org.apache.http.pool.AbstractConnPool;
import me.iblitzkriegi.vixio.org.apache.http.pool.ConnFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
class CPool
extends AbstractConnPool<HttpRoute, ManagedHttpClientConnection, CPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final Log log = LogFactory.getLog(CPool.class);
    private final long timeToLive;
    private final TimeUnit tunit;

    public CPool(ConnFactory<HttpRoute, ManagedHttpClientConnection> connFactory, int defaultMaxPerRoute, int maxTotal, long timeToLive, TimeUnit tunit) {
        super(connFactory, defaultMaxPerRoute, maxTotal);
        this.timeToLive = timeToLive;
        this.tunit = tunit;
    }

    @Override
    protected CPoolEntry createEntry(HttpRoute route, ManagedHttpClientConnection conn) {
        String id = Long.toString(COUNTER.getAndIncrement());
        return new CPoolEntry(this.log, id, route, conn, this.timeToLive, this.tunit);
    }

    @Override
    protected boolean validate(CPoolEntry entry) {
        return !((ManagedHttpClientConnection)entry.getConnection()).isStale();
    }
}

