/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Iterator;
import java.util.Map;
import me.iblitzkriegi.vixio.effects.EffLogin;
import me.iblitzkriegi.vixio.registration.ExprAnnotation;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import org.bukkit.event.Event;

@ExprAnnotation.Expression(name="NicknameOfUser", title="Nickname of User", desc="Get the Nickname of a User in a Guild", syntax="nickname of [user] %string% in [guild] %string%", returntype=String.class, type=ExpressionType.SIMPLE, example="SUBMIT EXAMPLES TO Blitz#3273")
public class ExprNicknameOf
extends SimpleExpression<String> {
    private Expression<String> vID;
    private Expression<String> vGuild;

    protected String[] get(Event e) {
        return new String[]{this.getNickname(e)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event event, boolean b) {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.vID = expr[0];
        this.vGuild = expr[1];
        return true;
    }

    private String getNickname(Event e) {
        Iterator<Map.Entry<String, JDA>> iterator = EffLogin.bots.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, JDA> jdaEntry = iterator.next();
            if (jdaEntry.getValue().getGuildById((String)this.vGuild.getSingle(e)) != null) {
                Guild guild = jdaEntry.getValue().getGuildById((String)this.vGuild.getSingle(e));
                Member member = guild.getMember(jdaEntry.getValue().getUserById((String)this.vID.getSingle(e)));
                if (member.getNickname() != null) {
                    return member.getNickname();
                }
                return member.getUser().getName();
            }
            return "User specified is not in the Guild you specified.";
        }
        return null;
    }
}

