/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Iterator;
import java.util.Map;
import me.iblitzkriegi.vixio.effects.EffLogin;
import me.iblitzkriegi.vixio.registration.CondAnnotation;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Role;
import org.bukkit.event.Event;

@CondAnnotation.Condition(name="UserHasRole", title="User has Role", desc="Check if a User has a specific role", syntax="[discord] user %string% has role %string% in %string%", example="on guild message receive seen by \\\"Rawr\\\":\\n\\tset {_args::*} to event-string split at \\\" \\\"\\n\\tset {_command} to {_args::1}\\n\\tremove {_args::1} from {_args::*}\\n\\tif {_command} starts with \\\"$permcheck\\\":\\n\\t\\tif user event-user has role \\\"Vixio Fanclub\\\" in event-guild:\\n\\t\\t\\tbroadcast \\\"Does\\\"")
public class CondUserHasRole
extends Condition {
    Expression<String> vRole;
    Expression<String> vGuild;
    Expression<String> vUser;

    public boolean check(Event e) {
        return this.hasRole(e);
    }

    public String toString(Event e, boolean b) {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.vUser = expr[0];
        this.vRole = expr[1];
        this.vGuild = expr[2];
        return true;
    }

    private Boolean hasRole(Event e) {
        for (Map.Entry<String, JDA> j : EffLogin.bots.entrySet()) {
            if (j.getValue().getGuildById((String)this.vGuild.getSingle(e)) != null) {
                Guild guild = j.getValue().getGuildById((String)this.vGuild.getSingle(e));
                if (guild.getMemberById((String)this.vUser.getSingle(e)) != null) {
                    Member member = j.getValue().getGuildById((String)this.vGuild.getSingle(e)).getMemberById((String)this.vUser.getSingle(e));
                    try {
                        Iterator<Role> iterator = guild.getRolesByName((String)this.vRole.getSingle(e), true).iterator();
                        if (!iterator.hasNext()) continue;
                        Role s = iterator.next();
                        return member.getRoles().contains(s);
                    }
                    catch (NullPointerException x) {
                        Skript.warning((String)"Could not find Role with that name.");
                        continue;
                    }
                }
                Skript.warning((String)"The user specified is not in the requested guild.");
                continue;
            }
            Skript.warning((String)"Could not find guild by that ID.");
        }
        return false;
    }
}

